package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.vo.CountVO;
import com.zzsn.event.vo.MediaVO;
import com.zzsn.event.vo.NegativeDataVO;


import java.util.List;
import java.util.Map;

/**
 * es统计查询
 *
 * @author lkg
 * @date 2024/1/24
 */
public interface EsStatisticsService {


    /**
     * 总体信息
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/1/25
     */
    CountVO total(String startTime, String endTime, Integer type);

    /**
     * 总体分析，获取总量和波峰值
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/1/25
     */
    Map<String, Object> totalAndMax(String subjectId, String startTime, String endTime);

    /**
     * 时间段内最新或最早的资讯
     *
     * @param subjectId 专题id
     * @param labelId   标签id
     * @param type      1-正序;2-倒序
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/1/25
     */
    Map<String, Object> findOne(String subjectId, String labelId, int type, String startTime, String endTime);

    /**
     * 情感判断分析
     *
     * @param subjectId 专题id
     * @param labelId   情感标签id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/1/25
     */
    CountVO orientation(String subjectId, String labelId, String startTime, String endTime, Integer type);

    /**
     * 影响力分析
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/1/25
     */
    List<CountVO> influence(String subjectId, String startTime, String endTime);

//    /**
//     * 媒体分布
//     *
//     * @param subjectId 专题id
//     * @param startTime 开始时间
//     * @param endTime   结束时间
//     * @author lkg
//     * @date 2024/1/24
//     */
//    List<MediaVO> media(String subjectId, String startTime, String endTime);

    /**
     * 来源分析
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      1-按小时;2-按天
     * @author lkg
     * @date 2024/1/23
     */
    List<CountVO> source(String subjectId, String startTime, String endTime, Integer type);

    /**
     * 平台活跃度--前十
     *
     * @param subjectId 专题id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/1/24
     */
    List<CountVO> origin(String subjectId, String startTime, String endTime);

//    /**
//     * 地域分析
//     *
//     * @param subjectId 专题id
//     * @param startTime 开始时间
//     * @param endTime   结束时间
//     * @author lkg
//     * @date 2024/1/25
//     */
//    List<CountVO> region(String subjectId, String startTime, String endTime);

    /**
     * 专题下的主流报道
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/1/29
     */
    String mainReport(String subjectId);


    /**
     * 某标签下资讯分页列表
     *
     * @param labelId   标签id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param pageNo    当前页
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/2/29
     */
    Page<NegativeDataVO> labelPageList(String labelId, String startTime, String endTime, Integer pageNo, Integer pageSize);

    CountVO flowData(String subjectId, String startTime, String endTime, Integer type);

    long totalCount(List<String> eventIdList, String startTime, String endTime);
}
