package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.vo.ReportExtendVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 报告表
 *
 * @author lkg
 * @date 2023/3/16
 */
@Data
@TableName("clb_report")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "clb_report", description = "报告表")
public class Report implements Serializable {

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 报告名称
     */
    @ApiModelProperty(value = "报告名称")
    @TableField("report_name")
    private String reportName;
    /**
     * 报告刊期
     */
    @ApiModelProperty(value = "报告刊期")
    @TableField("report_issue")
    private String reportIssue;
    /**
     * 报告内容
     */
    @ApiModelProperty(value = "报告内容")
    @TableField("content")
    private String content;
    /**
     * 开始时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间")
    @TableField("start_time")
    private Date startTime;
    /**
     * 结束时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
    @TableField("end_time")
    private Date endTime;
    /**
     * 文件地址
     */
    @ApiModelProperty(value = "文件地址")
    @TableField("file_path")
    private String filePath;
    /**
     * 预览地址
     */
    @ApiModelProperty(value = "预览地址")
    @TableField("preview")
    private String preview;
    /**
     * 模板id
     */
    @ApiModelProperty(value = "模板id")
    @TableField("template_id")
    private String templateId;
    /**
     * 报告类型id
     */
    @ApiModelProperty(value = "报告类型id")
    @TableField("type_id")
    private String typeId;
    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;
    /**
     * 专题id
     */
    @ApiModelProperty(value = "专题id")
    @TableField("subject_id")
    private String subjectId;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "项目id")
    @TableField("project_id")
    private String projectId;
    /**
     * 项目下的栏目id
     */
    @ApiModelProperty(value = "项目下的栏目id")
    @TableField("column_id")
    private String columnId;
    /**
     * 发布状态(0-不发布;1-发布)
     */
    @ApiModelProperty(value = "发布状态(0-不发布;1-发布)")
    @TableField("publish")
    private Integer publish;
    /**
     * 生成方式(1-自动;2-手动)
     */
    @ApiModelProperty(value = "生成方式(1-自动;2-手动)")
    @TableField("create_way")
    private Integer createWay;
    /**
     * 报告状态(0-禁用;1-正常)
     */
    @ApiModelProperty(value = "报告状态(0-禁用;1-正常)")
    @TableField("status")
    private Integer status;
    /**
     * 报告任务id
     */
    @ApiModelProperty(value = "报告任务id")
    @TableField("task_id")
    private String taskId;
    /**
     * 任务执行时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "任务执行时间")
    @TableField("task_execution_time")
    private Date taskExecutionTime;
    /**
     * 是否删除(0-否;1-是)
     */
    @ApiModelProperty(value = "是否删除(0-否;1-是)")
    @TableField("delete_status")
    private Integer deleteStatus;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    @TableField("create_by")
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    /**报告所属栏目信息*/
    @TableField(exist = false)
    private List<ReportExtendVo> reportExtendVoList;
}
