package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 事件挖掘任务
 *
 * @author lkg
 * @date 2024/9/13
 */
@Getter
@Setter
public class EventExtractTaskVO {

    private String id;
    private String taskName;
    private String projectName;
    private String columnId;
    private String columnName;
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date lastUpdateTime;
    private Integer taskStatus;
    private Integer extractEventCount;
    private Integer noCheckExtractEventCount;
}
