package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.entity.EventExtractTask;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.vo.EventExtractTaskVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_extract_task(事件抽取任务表)】的数据库操作Service
 * @createDate 2024-09-13 11:31:47
 */
public interface EventExtractTaskService extends IService<EventExtractTask> {

    /**
     * 事件抽取任务信息分页列表
     *
     * @param projectId  项目id
     * @param searchWord 搜索词
     * @param taskName   任务名称
     * @param startTime  开始时间
     * @param endTime    结束时间
     * @param pageNo     当前页
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/9/13
     */
    IPage<EventExtractTaskVO> pageList(String projectId, String searchWord, String taskName, String startTime, String endTime,
                                       Integer pageNo, Integer pageSize);
}
