package com.zzsn.event.controller.infosource;


import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.InfoSourceMain;
import com.zzsn.event.service.InfoSourceMainService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 信息源表 前端控制器
 * </p>
 *
 * @author obcy
 * @since 2025-06-19
 */
@RestController
@RequestMapping("/infoSourceMain")
public class InfoSourceMainController {
    @Autowired
    InfoSourceMainService infoSourceMainService;
    /**
     * 查询专题绑定的信息源列表
     */
    @ApiOperation(value = "专题绑定的信息源列表", notes = "专题绑定的信息源列表")
    @GetMapping(value = "/subjectBindList")
    public Result<?> subjectBindList(InfoSourceMain infoSourceMain,
                                     @RequestParam(name = "subjectId", defaultValue = "0") String subjectId,
                                     @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        IPage<InfoSourceMain> pageList = infoSourceMainService.subjectBindList(infoSourceMain, subjectId,pageNo, pageSize);
        return Result.OK(pageList);
    }


    /**
     * 专题绑定的信息源组列表
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "专题绑定/排除的信息源组列表", notes = "专题绑定/排除的信息源组列表")
    @GetMapping(value = "/bindInfoSourceMainGroupList")
    public Result<?> bindInfoSourceMainGroupList(@RequestParam(name = "id") String id) {
        JSONObject infoSourceGroupPages = infoSourceMainService.bindInfoSourceMainGroupList(id);
        return Result.OK(infoSourceGroupPages);
    }
    /**
     * 专题绑定的信息源组列表
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "专题绑定/排除的信息源列表", notes = "专题绑定/排除的信息源列表")
    @GetMapping(value = "/bindInfoSourceMainList")
    public Result<?> bindInfoSourceMainList(@RequestParam(name = "id") String id) {
        JSONObject infoSourceGroupPages = infoSourceMainService.bindInfoSourceMainList(id);
        return Result.OK(infoSourceGroupPages);
    }
    /**
     * 专题绑定的信息源组列表
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "专题绑定/排除的标签列表", notes = "专题绑定/排除的标签列表")
    @GetMapping(value = "/bindInfoSourceMainLabelList")
    public Result<?> bindInfoSourceLabelListNew(@RequestParam(name = "id") String id) {
        JSONObject infoSourceGroupPages = infoSourceMainService.bindInfoSourceMainLabelList(id);
        return Result.OK(infoSourceGroupPages);
    }

}
