package com.zzsn.event.constant;

public class Constants {

    private Constants() { }

    //事件专题-redis缓存key前缀
    public static final String SUBJECT_ANALYSIS_PRE = "SUBJECT_ANALYSIS::";
    //传播路径
    public static final String PROPAGATION_KEY = "PROPAGATION_PATH::";
    /**
     * 关键词数据入缓存 key前缀
     */
    public static final String KEY_WORDS_TO_REDIS_PREFIX = "KEY_WORDS_TO_REDIS::";
    public static final String MAX_TOTAL_HOT_SCORE = "MAX_TOTAL_HOT_SCORE";
    public static final String MAX_MEDIA_HOT_SCORE = "MAX_MEDIA_HOT_SCORE";
    public static final String MAX_WECHAT_HOT_SCORE = "MAX_WECHAT_HOT_SCORE";
    public static final String MAX_OTHER_HOT_SCORE = "MAX_OTHER_HOT_SCORE";

    public static String[] FETCH_FIELDS_STATISTIC = {"id", "subjectId","title","origin", "publishDate", "sourceAddress"};
    public static String[] FETCH_FIELDS_DATA = {"id", "subjectId", "title", "content", "publishDate", "origin", "sourceAddress"};
    //es 专题库索引
    public static final String SUBJECT_INDEX = "subjectdatabase";
    //es 采集库索引
    public static final String COLLECT_INDEX = "basedata";
    //专题事件脉络展示 伪事件脉络 的资讯数量阈值
    public static final int FAKE_NUM = 6;

    //kafka 发送分析命令 主题
    public static final String EVENT_VIEWPOINT_SEND_DATA = "event_viewpoint_send_data";
    //kafka 发送 事件脉络所需信息 主题
    public static final String EVENT_CONTEXT_SEND_TOPIC = "event_context_send_data";
    //kafka 发送 伪事件脉络所需信息 主题
    public static final String FAKE_EVENT_CONTEXT_SEND_TOPIC = "fake_event_context_send_data";


    //kafka 接收 观点分析结果 主题
    public static final String VIEWPOINT_RECEIVE_TOPIC = "event_viewpoint_result_data";
    //kafka 接收 事件脉络结果 主题
    public static final String EVENT_CONTEXT_RECEIVE_TOPIC = "event_topic_result_data";
    //kafka 接收 伪事件脉络结果 主题
    public static final String FAKE_EVENT_CONTEXT_RECEIVE_TOPIC = "fake_event_context-result_data";
    //kafka 接收 事件分析报告 主题
    public static final String EVENT_REPORT_RECEIVE_TOPIC = "event_report_result_data";

    //重复数索引ku
    public final static String ES_REPEAT_OLD = "repeathold";

    //处理后的专题资讯信息存储索引。
    public final static String ES_DATA_FOR_SUBJECT = "subjectdatabase_2023";


    public final static String HEADER_KEY = "X-Access-Token";
    //用户-普通用户
    public static final Integer COMMON_USER = 2;
    //用户-管理员用户
    public static final Integer ADMIN_USER = 3;
    /*数据权限类型*/
    public final static String PERMISSION_SUBJECT = "subject";


}
