package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectModelMap;
import com.zzsn.event.vo.PythonModelVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与模型关联表
 * @Author: jeecg-boot
 * @Date: 2021-12-16
 * @Version: V1.0
 */
@Mapper
public interface SubjectModelMapMapper extends BaseMapper<SubjectModelMap> {

    List<SubjectModelMap> selectModelBySubjectId(@Param("subjectId") String subjectId);

    /**
     * 专题绑定的模型信息列表
     *
     * @param subjectId 专题id
     * @param type      模型分类
     * @author lkg
     * @date 2024/12/23
     */
    List<PythonModelVo> bindModelByType(@Param("subjectId") String subjectId, @Param("type") String type);
}
