package com.zzsn.event.external.controller;

import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.config.properties.LlmProperties;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.external.entity.ExternalSubjectInfoSourceMap;
import com.zzsn.event.external.service.ExternalSubjectInfoSourceMapService;
import com.zzsn.event.external.vo.SubjectInfoVO;
import com.zzsn.event.external.vo.SubjectVO;
import com.zzsn.event.llm.LlmService;
import com.zzsn.event.service.CommonService;
import com.zzsn.event.service.InformationService;
import com.zzsn.event.service.SubjectService;
import com.zzsn.event.service.SubjectSimpleService;
import com.zzsn.event.service.impl.CaiJiCenterHttpService;
import com.zzsn.event.service.impl.ConfigurationMessageService;
import com.zzsn.event.util.HttpUtil;
import com.zzsn.event.util.ObjectUtil;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.*;
import com.zzsn.event.vo.es.DisplayInfo;
import com.zzsn.event.xxljob.entity.XxlJobInfo;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.CompletableFuture;

/**
 * @author lkg
 * @date 2025/8/12
 */
@Slf4j
@RestController
@RequestMapping("/external")
public class ExternalController {


    @Autowired
    private SubjectSimpleService subjectSimpleService;
    @Autowired
    private IXxlJobInfoService xxlJobInfoService;
    @Autowired
    private ExternalSubjectInfoSourceMapService externalSubjectInfoSourceMapService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private LlmService llmService;
    @Autowired
    private InformationService informationService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    SubjectService subjectService;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private CaiJiCenterHttpService caiJiCenterHttpService;
    @Autowired
    private ConfigurationMessageService configurationMessageService;
    @Resource
    private LlmProperties llmProperties;

    @Value("${caiji.keywordCrawler.url:}")
    private String keywordCrawlerUrl;
    @Value("${translate.url:}")
    private String TRANSLATE_URL;
    @Value("${kafka.topic.subject.run:}")
    private String SUBJECT_MODEL_KAFKA_CHANNEL;


    /**
     * 分页列表查询-研究中心
     *
     * @param subjectCondition 搜索条件
     * @param pageNo           当前页
     * @param pageSize         每页返回条数
     * @author lkg
     * @date 2025/1/7
     */
    @GetMapping(("/pageList"))
    public Result<?> researchCenterPageList(SubjectCondition subjectCondition,
                                            @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                            @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                            @RequestParam(required = false) String flagCode, HttpServletRequest request) {
        UserVo loginUser = UserUtil.getLoginUser();
        Page<SubjectPage> pageList = subjectService.researchCenterPageList(subjectCondition, pageNo, pageSize, flagCode, request, loginUser.getUsername());
        List<SubjectPage> records = pageList.getRecords();
        if (CollectionUtils.isNotEmpty(records)) {
            Date now = new Date();
            for (SubjectPage record : records) {
                Date timeDisable = record.getTimeDisable();
                String estimateStatus = record.getEstimateStatus();
                Integer status = record.getStatus();
                if (status == 0) {
                    record.setCollectStatus("未启用");
                } else {
                    if (timeDisable != null) {
                        if (timeDisable.before(now)) {
                            if ("已完成".equals(estimateStatus) && status == 1) {
                                record.setCollectStatus("已完成");
                            } else if (!"已完成".equals(estimateStatus) && status == 1) {
                                record.setCollectStatus("采集中");
                            }
                        } else if (status == 1){
                            record.setCollectStatus("采集中");
                        }
                    } else if (status == 1){
                        record.setCollectStatus("采集中");
                    }
                }
            }
        }
        return Result.OK(pageList);
    }

    /**
     * 创建专题
     *
     * @param subjectVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/createSubject")
    public Result<?> createSubject(@RequestBody SubjectVO subjectVO) {
        subjectVO.setDataScope("1");
        SubjectSimpleVO subjectSimpleVO = new SubjectSimpleVO();
        BeanUtils.copyProperties(subjectVO, subjectSimpleVO);
        Subject subject = subjectSimpleService.createExternalSubject(subjectSimpleVO);
        CompletableFuture.runAsync(() -> {
            //插入xxlJob
            xxlJobInfoService.subjectInsert(subject);
        });
        return Result.OK(subject.getId());
    }

    /**
     * 编辑专题
     *
     * @param subjectVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/updateSubject")
    public Result<?> updateSubject(@RequestBody SubjectVO subjectVO) {
        subjectVO.setDataScope("1");
        SubjectSimpleVO subjectSimpleVO = new SubjectSimpleVO();
        BeanUtils.copyProperties(subjectVO, subjectSimpleVO);
        subjectSimpleService.editExternalSubject(subjectSimpleVO);
        return Result.OK();
    }


    /**
     * 更新状态
     *
     * @param subject
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/updateStatus")
    public Result<?> updateStatus(@RequestBody Subject subject) {
        subjectService.updateStatus(subject);
        Subject byId = subjectService.getById(subject.getId());
        List<XxlJobInfo> list = xxlJobInfoService.list(Wrappers.<XxlJobInfo>lambdaQuery().eq(XxlJobInfo::getInfoSourceCode, byId.getSubjectCode()));
        if (CollectionUtils.isNotEmpty(list)) {
            xxlJobInfoService.update(Wrappers.<XxlJobInfo>lambdaUpdate()
                    .eq(XxlJobInfo::getInfoSourceCode, byId.getSubjectCode())
                    .set(XxlJobInfo::getTriggerStatus, byId.getStatus()));
        } else {
            xxlJobInfoService.subjectInsert(byId);
        }
        if (subject.getStatus() == 1) {
            kafkaTemplate.send(SUBJECT_MODEL_KAFKA_CHANNEL, byId.getSubjectCode());
            configurationMessageService.bindKeyWordsSend(subject.getId(), 1);
        }
        try {
            String res = caiJiCenterHttpService.subjectStatusEdit(subject.getStatus(), subject.getId());
            cn.hutool.json.JSONObject entries = JSONUtil.parseObj(res);
            //获取code状态码
            Integer code = entries.getInt("code");
            if (cn.hutool.core.util.ObjectUtil.isEmpty(code) || code != 200) {
                log.error("专题状态同步采集失败{}", res);
            }
        } catch (Exception e) {
            log.error("专题状态同步采集失败{}", e.getMessage(), e);
        }
        return Result.OK();
    }


    /**
     * 优化描述
     *
     * @param remark 描述
     * @author lkg
     * @date 2025/8/25
     */
    @GetMapping("/optimizeDescription")
    public Result<?> optimizeDescription(@RequestParam String remark, @RequestParam String language) {
        String languageCN = "中文简体";
        if ("zh-CN".equals(language)) {
            languageCN = "中文，且为中文简体";
        } else if ("en".equals(language)) {
            languageCN = "英文";
        } else if ("ja".equals(language)) {
            languageCN = "日文";
        }
        String prompt = "【角色】 你是一名资深【行业分析师】和【技术文档撰写者】。你的任务是将一个简短的主题转化为一段定义清晰、内容充实、客观中立的专题概述。\n" +
                "【核心任务】 根据用户提供的一个简短主题名称或初步想法，将其扩展成一段约150字的、详尽且准确的专题描述。这段描述需要全面覆盖该主题的核心定义、背景、关键组成部分、重要影响或相关应用场景，语言需保持专业、精炼和高信息密度，避免主观评价和浮夸修辞。\n" +
                "【要求】\n" +
                "客观全面：内容必须基于事实，涵盖主题，准确识别用户意图。\n" +
                "意图扩展：识别用户意图，将意图扩展，而不是回答这个问题\n" +
                "信息密集：优先使用名词和专业术语，尽量保留用户输入的关键词，确保段落内含大量关键实体和概念，为后续关键词提取提供丰富素材。\n" +
                "逻辑连贯：语句之间逻辑顺畅，形成一段完整的概述，而非关键词罗列。\n" +
                "精准简洁：严格控制字数在150字左右，直达核心，避免冗长。\n" +
                "输出语种：输出的文字必须是" + languageCN + "\n" +
                "最终输出：请直接生成一段约150字的专题描述，无需任何前置说明、标题或分点。\n" +
                "【输入输出示例】\n" +
                "示例：\n" +
                "输入： 特斯拉刹车失灵\n" +
                "输出： 该专题聚焦于特斯拉电动汽车系列车型涉及的刹车系统性能与安全问题。近年来，全球多地车主报告在驾驶过程中遭遇疑似刹车失灵或制动距离异常延长的案例，引发了消费者对车辆安全性的广泛担忧。事件导致了多起交通事故，并促使美国国家公路交通安全管理局等权威机构启动缺陷调查。专题将涵盖相关事故报告、技术分析、监管机构的调查进展、特斯拉官方的回应及后续软件更新措施，旨在全面审视此类事件的真实性与潜在技术根源。";
        String description = llmService.model("qwen", "qwen-max-latest", prompt, remark);
        Map<String, String> resultMap = new HashMap<>();
        resultMap.put("language", language);
        resultMap.put("model", description);
        return Result.OK(resultMap);
    }


    /**
     * 采集词推荐
     *
     * @param remark 专题描述
     * @author lkg
     * @date 2025/8/12
     */
    @GetMapping("/crawlerWordRecommend")
    public Result<?> crawlerWordRecommend(@RequestParam String remark) {
        String prompt = "你是一个专业信息采集助手，根据用户专题描述生成关键词表达式：\n" +
                "1. 用 + 表示与关系（必须同现），| 表示或关系（任一出现），用()分组\n" +
                "2. 执行三步操作：\n" +
                "   (1) 理解语意，识别用户需求，提取核心实体（如企业/产品名），实体词语必须完整不能有歧义\n" +
                "   (2) 将抽象词拆解为3-5个具体场景词（如\"动向\"→\"上升|下降|波动|结构调整\"）\n" +
                "   (3) 扩展同义词/行业关联词\n" +
                "3. 排除时间词，|两边只能是单个词语，不能是括号词组，\n" +
                "4.+号不超过2个，尽量使用两组词表达，最多使用三组词\n" +
                "5. 输出仅含表达式\n" +
                "\n" +
                "示例： \n" +
                "描述：苹果新款iPhone发布引发市场反响\n" +
                "输出：(苹果|iPhone)+(発売|価格|予約状況|市場シェア|消費者反応)";
        LlmProperties.ModelConfig modelConfig = llmProperties.getModelConfig("qwen");
        modelConfig.setDefaultModel("qwen-max-latest");
        modelConfig.setTemperature(0.1f);
        String crawlerWord = llmService.qwenModel(modelConfig, prompt, remark);
        return Result.OK(crawlerWord);
    }

    /**
     * 绑定信息源分页列表
     *
     * @param subjectId 专题id
     * @param pageNo    页码
     * @param pageSize  每页返回条数
     * @author lkg
     * @date 2025/8/12
     */
    @GetMapping("/bindSourcePageList")
    public Result<?> bindSourceList(@RequestParam String subjectId,
                                    @RequestParam(defaultValue = "1") Integer pageNo,
                                    @RequestParam(defaultValue = "10") Integer pageSize) {
        Page<ExternalSubjectInfoSourceMap> page = new Page<>(pageNo, pageSize);
        LambdaQueryWrapper<ExternalSubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ExternalSubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(ExternalSubjectInfoSourceMap::getType, 1);
        Page<ExternalSubjectInfoSourceMap> list = externalSubjectInfoSourceMapService.page(page, queryWrapper);
        return Result.OK(list);
    }


    /**
     * 下载导入信息源
     *
     * @author lkg
     * @date 2024/06/21
     */
    @GetMapping("/downloadInfoSourceTemplate")
    public void downloadResearchTemplate(HttpServletResponse response) {
        String filePath = "subjectDataImport/导入信息源模板.xlsx";
        commonService.downloadTemplate(response, filePath);
    }


    /**
     * 批量导入绑定得信息源
     *
     * @author lkg
     * @date 2025/8/12
     */
    @PostMapping("/importInfoSource")
    public Result<?> importInfoSource(HttpServletRequest request) {
        String subjectId = request.getParameter("subjectId");
        if (StringUtils.isBlank(subjectId)) {
            return Result.FAIL(500, "专题id不能为空");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        if (fileMap.size() < 1) {
            return Result.FAIL(500, "请上传excel文件");
        }
        MultipartFile multipartFile = fileMap.get(new ArrayList<>(fileMap.keySet()).get(0));
        int index = multipartFile.getOriginalFilename().lastIndexOf(".");
        String fileSuffix = multipartFile.getOriginalFilename().substring(index + 1);
        if ("xls".equals(fileSuffix) || "xlsx".equals(fileSuffix)) {
            try {
                ExcelReader reader = ExcelUtil.getReader(multipartFile.getInputStream());
                Map<String, String> header = new HashMap<>();
                header.put("信息源名称", "infoSourceName");
                header.put("信息源地址", "infoSourceUrl");
                reader.setHeaderAlias(header);
                List<ExternalSubjectInfoSourceMap> infoSourceList = reader.read(0, 1, ExternalSubjectInfoSourceMap.class);
                infoSourceList.forEach(infoSource -> {
                    infoSource.setSubjectId(subjectId);
                    infoSource.setType(1);
                });
                externalSubjectInfoSourceMapService.saveBatch(infoSourceList);
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return Result.FAIL(500, "不支持的文件类型");
        }
        return Result.OK();
    }

    /**
     * 绑定信息源
     *
     * @param externalSubjectInfoSourceMap 参数
     * @author lkg
     * @date 2025/8/12
     */
    @PostMapping("/bindSource")
    public Result<?> bindSource(@RequestBody ExternalSubjectInfoSourceMap externalSubjectInfoSourceMap) {
        externalSubjectInfoSourceMap.setType(1);
        externalSubjectInfoSourceMapService.save(externalSubjectInfoSourceMap);
        return Result.OK();
    }

    /**
     * 解绑信息源
     *
     * @param ids id集合
     * @author lkg
     * @date 2025/8/12
     */
    @GetMapping("/unBindSource")
    public Result<?> bindSource(@RequestParam List<String> ids) {
        externalSubjectInfoSourceMapService.removeByIds(ids);
        return Result.OK();
    }

    /**
     * 专题详情
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/9
     */
    @GetMapping("/queryInfo")
    public Result<?> queryInfo(@RequestParam String subjectId) {
        SubjectInfoVO subjectInfoVO = new SubjectInfoVO();
        SubjectDetailVO subjectDetailVO = subjectSimpleService.queryInfo(subjectId);
        BeanUtils.copyProperties(subjectDetailVO, subjectInfoVO);
        LambdaQueryWrapper<ExternalSubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ExternalSubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(ExternalSubjectInfoSourceMap::getType, 1);
        subjectInfoVO.setInfoSourceList(externalSubjectInfoSourceMapService.list(queryWrapper));
        return Result.OK(subjectInfoVO);
    }


    /**
     * 配置信息推送给采集
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/8/12
     */
    //@GetMapping("/pushToCaiji")
    public Result<?> pushToCaiji(@RequestParam String subjectId) {
        SubjectInfoVO subjectInfoVO = new SubjectInfoVO();
        SubjectDetailVO subjectDetailVO = subjectSimpleService.queryInfo(subjectId);
        BeanUtils.copyProperties(subjectDetailVO, subjectInfoVO);
        LambdaQueryWrapper<ExternalSubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ExternalSubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(ExternalSubjectInfoSourceMap::getType, 1);
        subjectInfoVO.setInfoSourceList(externalSubjectInfoSourceMapService.list(queryWrapper));
        try {
            HttpUtil.doPost(keywordCrawlerUrl, JSONObject.from(subjectInfoVO), 30000);
            log.info("【{}】-通知元搜索采集数据", subjectDetailVO.getSubjectName());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return Result.OK();
    }


    /**
     * 汇总摘要
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/8/16
     */
    @GetMapping("/gatherSummary")
    public Result<?> gatherSummary(@RequestParam String subjectId, @RequestParam String language) {
        String key = "GATHER_SUMMARY::" + subjectId;
        if (redisUtil.hasKey(key)) {
            Object data = redisUtil.get(key);
            Map<String, Object> map = (Map<String, Object>) data;
            List<String> idList = JSON.parseArray(map.get("idList").toString(), String.class);
            InfoDataSearchCondition searchCondition = new InfoDataSearchCondition();
            searchCondition.setSubjectId(subjectId);
            searchCondition.setCategory(2);
            searchCondition.setColumn("score");
            searchCondition.setPageSize(20);
            IPage<DisplayInfo> pageList = informationService.subjectPageList(searchCondition);
            List<DisplayInfo> records = pageList.getRecords();
            if (CollectionUtils.isNotEmpty(records)) {
                List<String> ids = new ArrayList<>();
                records.forEach(record -> ids.add(record.getId()));
                if (!CollectionUtils.isEqualCollection(ids, idList)) {
                    Map<String, Object> resultMap = generateSummary(subjectId, records, language);
                    return Result.OK(resultMap);
                }
            }
            return Result.OK(map);
        } else {
            List<DisplayInfo> dataList = getDataList(subjectId);
            return Result.OK(generateSummary(subjectId, dataList, language));
        }
    }

    /**
     * 获取汇总摘要
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/8/16
     */
    //@GetMapping("/getGatherSummary")
    public Result<?> getGatherSummary(@RequestParam String subjectId) {
        return Result.OK(redisUtil.get("GATHER_SUMMARY::" + subjectId));
    }

    /**
     * 翻译
     *
     * @param params 参数
     * @author lkg
     * @date 2024/8/21
     */
    @PostMapping("/translate")
    public Result<?> translate(@RequestBody JSONObject params) {
        String language = params.getString("language");
        String summary = params.getString("summary");
        TranslateVO translateVO = new TranslateVO();
        translateVO.setFrom("auto");
        translateVO.setTo(language);
        List<String> content = new ArrayList<>();
        content.add(summary);
        translateVO.setContent(content);
        String result = null;
        try {
            String s = HttpUtil.doPost(TRANSLATE_URL, ObjectUtil.objectToJSONObject(translateVO), 10000);
            List<String> data = JSONArray.parseArray(s, String.class);
            result = Jsoup.parse(data.get(0)).text();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Result.OK(result);
    }


    private List<DisplayInfo> getDataList(String subjectId) {
        InfoDataSearchCondition searchCondition = new InfoDataSearchCondition();
        searchCondition.setSubjectId(subjectId);
        searchCondition.setCategory(2);
        searchCondition.setColumn("score");
        searchCondition.setPageSize(20);
        IPage<DisplayInfo> pageList = informationService.subjectPageList(searchCondition);
        return pageList.getRecords();
    }

    private Map<String, Object> generateSummary(String subjectId, List<DisplayInfo> records, String language) {
        Map<String, Object> resultMap = null;
        if (CollectionUtils.isNotEmpty(records)) {
            JSONObject params = new JSONObject();
            List<String> idList = new ArrayList<>();
            List<JSONObject> summaryList = new ArrayList<>();
            records.forEach(record -> {
                idList.add(record.getId());
                JSONObject summary = new JSONObject();
                summary.put("summary", record.getSummary());
                summaryList.add(summary);
            });
            Subject subject = subjectService.getById(subjectId);
            params.put("subject", subject.getSubjectName());
            params.put("summaryList", summaryList);
            String languageCN = "中文简体";
            if ("zh-CN".equals(language)) {
                languageCN = "中文，且为中文简体";
            } else if ("en".equals(language)) {
                languageCN = "英文";
            } else if ("ja".equals(language)) {
                languageCN = "日文";
            }
            String prompt = "#目标：\n" +
                    "将用户上传的多篇资讯摘要文本和主题整合为一段连贯、精炼的综合摘要（约500字）。要求：\n" +
                    "1）将输入的json解析，subject是主题，summary是摘要，提炼核心主题与高度共识的关键发现；\n" +
                    "2）信息提取：必须深入挖掘并优先包含以下有价值的信息：\n" +
                    "具体数据与量化指标（如：成功率、误差率、性能提升百分比、样本规模）。\n" +
                    "具体方法、技术或模型名称（如：LSTM、Transformer、ResNet-50）。\n" +
                    "明确的研究结论（如：“证明A方法在B任务上优于C方法”）。\n" +
                    "研究间的直接对比或矛盾（如：“研究一报告了85%的准确率，而研究二在相同条件下仅复现出70%的结果，推测源于数据预处理差异”）。\n" +
                    "明确指出的局限性与未来挑战（如：“所有研究均未在跨语言环境下进行验证”）。\n" +
                    "3）避免内容：摒弃模糊的表述（如“取得了良好效果”、“具有重大意义”），除非是连接上下文的必要过渡。\n" +
                    "4）所有信息必须来源于提供的摘要，不可以自行联想\n" +
                    "5）语言需严谨中性，直接输出整合后的段落，无需分节分段或小标题。\n" +
                    "\n" +
                    "#约束：\n" +
                    "1.输出禁止分段\n" +
                    "2.输出的文字必须是" + languageCN + "\n" +
                    "3.摘要长度必须为500字以内\n" +
                    "\n" +
                    "#使用示例：\n" +
                    "输入：\n" +
                    "{\"subject\":\"机器学习可解释性\",\"summaryList\":[{\"summary\":\"提出梯度解释法...验证准确率提升15%\"},{\"summary\":\"对比LIME与SHAP...指出计算效率缺陷\"},{\"summary\":\"医疗领域应用研究...模型透明度不足影响临床采纳\"}]}\n" +
                    "输出（示例段落）：\n" +
                    "多篇关于机器学习可解释性（XAI）的研究聚焦于提升复杂模型透明度。核心共识在于有效解释技术（如梯度解释法、LIME、SHAP）能增强用户信任并提升决策准确率。然而，在方法实用性上存在分歧，部分研究指出主流技术存在显著计算效率缺陷，尤其在资源受限场景；同时，医疗领域应用突显透明度不足是阻碍临床采纳的关键瓶颈。研究趋势显示从开发基础解释方法（如早期梯度法）转向评估实际场景效能及效率优化。当前主要知识缺口在于缺乏统一标准评估解释的可靠性与临床相关性，亟需开发兼顾高效性和领域适配性的XAI解决方案。";
            String model = llmService.model("qwen", "qwen-max-latest", prompt, JSONObject.toJSONString(params));
            if (StringUtils.isNotBlank(model)) {
                resultMap = new HashMap<>();
                resultMap.put("idList", idList);
                resultMap.put("language", language);
                resultMap.put("model", model);
                redisUtil.set("GATHER_SUMMARY::" + subjectId, resultMap);
            }
        }
        return resultMap;
    }
}
