package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.util.tree.Node;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lenovo
* @description 针对表【label_entity】的数据库操作Mapper
* @createDate 2023-08-28 15:02:50
* @Entity com.zzsn.clb.scheduletask.entity.LabelEntity
*/
@Mapper
public interface LabelEntityMapper extends BaseMapper<LabelEntity> {



    /**
     * 根据分类获取标签列表
     *
     * @param labelTypeId 标签分类id
     * @author lkg
     * @date 2024/1/22
     */
    List<LabelEntity> listByType(@Param("labelTypeId") String labelTypeId);

    /**
     * 国际地域信息列表
     *
     * @author lkg
     * @date 2024/4/9
     */
    List<Node> regionInList();
    /**
     * 国际地域信息列表
     *
     * @author lkg
     * @date 2024/4/9
     */
    List<Node> regionOutList();
}




