package com.zzsn.event.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.Event;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.vo.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

 /**
 * 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Slf4j
@Api(tags="事件")
@RestController
@RequestMapping("/event/event")
public class EventController  {
	@Autowired
	private IEventService eventService;
	
	/**
	 * 分页列表查询
	 *
	 * @param event
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@ApiOperation(value="事件-分页列表查询", notes="事件-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(Event event,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<Event> queryWrapper = new QueryWrapper<>();
		Page<Event> page = new Page<Event>(pageNo, pageSize);
		IPage<Event> pageList = eventService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 * 添加
	 *
	 * @param event
	 * @return
	 */
	@ApiOperation(value="事件-添加", notes="事件-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody Event event) {
		eventService.save(event);
		return Result.OK("添加成功！");
	}
	
	/**
	 * 编辑
	 *
	 * @param event
	 * @return
	 */
	@ApiOperation(value="事件-编辑", notes="事件-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody Event event) {
		eventService.updateById(event);
		return Result.OK("编辑成功!");
	}
	
	/**
	 * 通过id删除
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件-通过id删除", notes="事件-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		eventService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 * 批量删除
	 *
	 * @param ids
	 * @return
	 */
	@ApiOperation(value="事件-批量删除", notes="事件-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.eventService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件-通过id查询", notes="事件-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		Event event = eventService.getById(id);
		return Result.OK(event);
	}



}
