package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.vo.KeywordsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
@Mapper
public interface KeyWordsMapper extends BaseMapper<KeyWords> {

    List<KeyWordsPage> pageList(@Param("keyWords") KeyWords keyWords, @Param("typeIds") List<String> typeIds, @Param("offset") Integer offset,
                                @Param("pageSize") Integer pageSize, @Param("subjectId") String subjectId, @Param("search") int search, @Param("bindingType") String bindingType);

    Integer totalCount(@Param("keyWords") KeyWords keyWords, @Param("typeIds") List<String> typeIds, @Param("subjectId") String subjectId, @Param("search") int search, @Param("bindingType") String bindingType);

    KeyWordsPage selectKeyWordsById(@Param("keyWordsId") String keyWordsId);

    List<KeyWordsPage> selectKeyWordsListById(@Param("subjectId") String subjectId);

    /**
     * 事件绑定关键词信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/9/12
     */
    KeywordsVO keywordInfoByEventId(@Param("eventId") String eventId);


    /**
     * 专题绑定关键词信息-分页列表
     *
     * @param subjectIds 专题id集合
     * @param groupName  词组名称
     * @param wordName   关键词名称
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/5/7
     */
    List<KeyWordsPage> bindKeyWordsList(@Param("subjectIds") List<String> subjectIds,
                                        @Param("groupName") String groupName, @Param("wordName") String wordName,
                                        @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题绑定关键词信息-总数量
     *
     * @param subjectIds 专题id集合
     * @param groupName  词组名称
     * @param wordName   关键词名称
     * @author lkg
     * @date 2024/5/7
     */
    Long bindKeyWordsCount(@Param("subjectIds") List<String> subjectIds, @Param("groupName") String groupName, @Param("wordName") String wordName);

    /**
     * 专题/事件绑定关键词组的数量
     *
     * @param subjectId 专题/事件id
     * @author lkg
     * @date 2024/12/19
     */
    Integer bindCount(@Param("subjectId") String subjectId);


    List<KeyWordsPage> pageListByTypeIdList(@Param("ids") List<String> ids, @Param("subjectId") String subjectId, @Param("status") int status, @Param("bindingType") String bindingType);

    Integer countByTypeAndIdList(@Param("finalIdList") List<String> finalIdList, @Param("subjectId") String subjectId);
}
