package com.zzsn.event.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.ScoreModel;
import com.zzsn.event.mapper.ScoreModelMapper;
import com.zzsn.event.service.CommonService;
import com.zzsn.event.service.ScoreModelService;
import com.zzsn.event.util.HttpUtil;
import com.zzsn.event.vo.ScoreModelVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

/**
 * @Description: 打分模型
 * @Author: jeecg-boot
 * @Date:   2021-12-17
 * @Version: V1.0
 */
@Service
public class ScoreModelServiceImpl extends ServiceImpl<ScoreModelMapper, ScoreModel> implements ScoreModelService {

    @Autowired
    private CommonService commonService;

    @Value("${python.scoreModelUrl}")
    private String scoreModelUrl;

    @Override
    public void addOrUpdate(ScoreModelVo scoreModel,Integer category) {
        LambdaQueryWrapper<ScoreModel> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ScoreModel::getSubjectId,scoreModel.getSubjectId())
                        .eq(ScoreModel::getType,scoreModel.getType());
        baseMapper.delete(queryWrapper);
        ScoreModel scoreModelNew = new ScoreModel();
        BeanUtils.copyProperties(scoreModel, scoreModelNew);
        baseMapper.insert(scoreModelNew);
        if (scoreModel.getChangeType() == 1) {
            JSONObject jsonObject = commonService.siteInfo(scoreModel.getSubjectId(), scoreModel.getType(),category);
            //调用python接口
            try {
                HttpUtil.doPost(scoreModelUrl, jsonObject, 3000);
            } catch (IOException e) {
                log.error("传递专题配置信息异常!");
            }
        }
    }

    @Override
    public List<ScoreModelVo> queryScoreModel(String subjectId, String type){
        return baseMapper.selectByInfo(subjectId, type);
    }
}
