package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 网络事件表
* @TableName event_network
*/
@Data
@TableName("event_network")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="event_network对象", description="网络事件")
public class EventNetwork implements Serializable {

    /**
    * 主键id
    */
    @TableId(value = "id",type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 标题
    */
    private String title;
    /**
    * 图片地址
    */
    private String picture;
    /**
    * 热度
    */
    private Integer hot;
    /**
    * 发布日期
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date publishDate;
    /**
    * 是否最新(1-是;0-否)
    */
    private Integer latest;
    /**
    * 是否所要事件(1-是;0-否)[政治经济领域相关]
    */
    private Integer ynNeed;
    /**
    * 来源类型(1-百度;2-新浪)
    */
    private Integer type;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
    * 创建人
    */
    private String createBy;
    /**
    * 更新时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**
    * 更新人
    */
    private String updateBy;
}
