package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.InfoSourceGroup;
import com.zzsn.event.vo.GroupTreeVO;
import com.zzsn.event.vo.InfoSourceGroupPage;

import java.util.List;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
public interface InfoSourceGroupService extends IService<InfoSourceGroup> {

    /**
     * 获取详情
     *
     * @param groupId 信息源组id
     * @author lkg
     * @date 2024/12/18
     */
    InfoSourceGroup getGroupById(String groupId);

    /**
     * 获取信息源组下绑定的信息源id集合
     *
     * @param groupIds 信息源组id集合
     * @author lkg
     * @date 2024/12/18
     */
    List<String> selectInfoSourceByGroupIds(List<String> groupIds);

    /**
     * 获取专题/事件绑定的信息源组列表
     *
     * @param subjectId 专题/事件id
     * @author lkg
     * @date 2024/12/18
     */
    List<InfoSourceGroupPage> bindInfoSourceList(String subjectId);

    /**
     * 信息源栏目组组和栏目组分类组成的树型结构
     *
     * @author lkg
     * @date 2024/12/23
     */
    List<GroupTreeVO> GroupAndTypeTree();

    /**
     * 新信息源组和分类组成的树型结构
     *
     * @author lkg
     * @date 2024/12/23
     */
    List<GroupTreeVO> infourceMainGroupAndTypeTree();


}
