package com.zzsn.event.vo;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.entity.SubjectSampleFile;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 *  专题详情信息(包含样例文章)
 *
 * @author lkg
 * @date 2025/1/8
 */
@Data
public class SubjectDetailVO {

    /**专题名称*/
    private String subjectName;
    /**专题描述*/
    private String remark;
    /**开始时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeEnable;
    /**结束时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeDisable;
    /**是否公开(0-未公开;1-已公开)*/
    private Integer facePublic;
    /**数据来源(0-平台数据;1-全网搜)*/
    private Integer dataSource;
    /**划分专题库*/
    private String library;
    /**第一次启用时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date firstOpenTime;

    /**专题分类id*/
    private String subjectTypeId;
    /**专题分类名称*/
    private String subjectTypeName;
    /**专题下的样例文章*/
    private List<SubjectSampleFile> sampleFileList;
    /**关键词信息*/
    private List<SearchWordVO> keywords;
    /**预估状态*/
    private String estimateStatus;
}
