package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 专题与模型关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-16
 * @Version: V1.0
 */
@Data
@TableName("subject_model_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="subject_model_map对象", description="专题与模型关联表")
public class SubjectModelMap implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**专题id*/
	@Excel(name = "专题id", width = 15)
    @ApiModelProperty(value = "专题id")
    private String subjectId;
	/**模型id*/
	@Excel(name = "模型id", width = 15)
    @ApiModelProperty(value = "模型id")
    private String modelId;
	/**种类（1：去重模型  2：筛选模型  3：标签模型）*/
	@Excel(name = "种类（1：去重模型  2：筛选模型  3：标签模型）", width = 15)
    @ApiModelProperty(value = "种类（1：去重模型  2：筛选模型  3：标签模型）")
    private String type;

    @Excel(name = "新旧模型标识，1为新模型标识", width = 15)
    @ApiModelProperty(value = "新旧模型标识")
    private Integer sign;

    @TableField(exist = false)
	private String modelName;

	/**模型服务名称*/
    @TableField(exist = false)
    private String serviceName;
    @TableField(exist = false)
    private String url;
}
