package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.xxljob.entity.InfoSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date: 2022-01-18
 * @Version: V1.0
 */
@Mapper
public interface InfoSourceMapper extends BaseMapper<InfoSource> {


    /**
     * 信息源信息列表
     *
     * @param sourceIdList 信息源id集合
     * @author lkg
     * @date 2024/5/7
     */
    List<InfoSourceVo> queryInfoSource(@Param("sourceIdList") List<String> sourceIdList);

    /**
     * 专题绑定的信息源集合
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @param offset              偏移量
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/4/24
     */
    List<String> bindSourceIdList(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectIds") List<String> subjectIds, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题绑定的信息源总数量
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @author lkg
     * @date 2024/4/24
     */
    Long bindSourceIdCount(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectIds") List<String> subjectIds);

    /**
     * 专题直接屏蔽的信息源列表(不包括专题屏蔽的信息源组下的信息源)
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectId           专题id
     * @param offset              偏移量
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/4/30
     */
    List<InfoSourceVo> unBindSourcePageList(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectId") String subjectId, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题直接屏蔽的信息源数量(不包括专题屏蔽的信息源组下的信息源)
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectId           专题id
     * @author lkg
     * @date 2024/4/30
     */
    Long unBindSourceCount(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectId") String subjectId);

}
