package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectModelMap;
import com.zzsn.event.vo.PythonModelVo;

import java.util.List;

/**
 * @Description: 专题与模型关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-16
 * @Version: V1.0
 */
public interface ISubjectModelMapService extends IService<SubjectModelMap> {

    List<SubjectModelMap> selectModelBySubjectId(String subjectId);

    /**
     * 专题绑定的模型信息列表
     *
     * @param subjectId 专题id
     * @param type      模型分类
     * @author lkg
     * @date 2024/12/23
     */
    List<PythonModelVo> bindModelByType(String subjectId, String type);
}
