package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date:   2021-12-15
 * @Version: V1.0
 */
@Data
@TableName("subject")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class Subject implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**专题编码*/
    private String subjectCode;
	/**专题名称*/
    private String subjectName;
	/**图片策略*/
    private String picturePolicy;
	/**网页策略*/
    private String pagePolicy;
	/**状态*/
    private Integer status;
	/**是否公开(0-未公开;1-已公开)*/
    private Integer facePublic;
	/**数据来源(0-平台数据;1-全网搜)*/
    private Integer dataSource;
	/**启用时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeEnable;
	/**停用时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeDisable;
	/**划分专题库*/
    private String library;
    /**定时单位(1分；2小时；3日；4月)*/
    private String unit;
    /**定时数值*/
    private Integer space;
    /**cron表达式*/
    private String cron;
    /**是否提取热词*/
    private String ynExtractHotWords;
    /**事件专题增量分析规则*/
    private Integer increAnaRule;
    /**事件专题总量分析规则*/
    private Integer totalAnaRule;
    /**事件专题时间间隔分析规则(天)*/
    private Integer timeAnaRule;
    /**专题最近一次分析时间*/
    private Date analysisTime;
    /**外事办映射id*/
    private Integer wsbMapId;
	/**创建人*/
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
	/**更新人*/
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
	/**所属部门*/
    private String sysOrgCode;
    /**所属客户*/
    private String customerId;
    /**项目id*/
    private String projectId;
    /**专题类型(1-普通专题;3-嵌套专题)*/
    private Integer subjectType;
    /**专题信息所在es库名称*/
    private String esIndex;
    /**排序号*/
    private Integer sortOrder;
    /**企业数据类型[0-研报；1-年报；2-动态；3-公告]*/
    private String additionDataType;
    private Integer enterpriseCheck;
    /**备注*/
    private String remark;
    /**是否处理无发布时间的资讯：1是，0否*/
    private Integer noPublishTimeFlag;
    /**是否是平台创建的专题（0否--外部创建 1是--平台创建 ）*/
    private String isPlatform;
    /**第一次启用时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date firstOpenTime;
    /**预估状态*/
    private String estimateStatus;
    /** 环境 1-测试 2-正式 */
    private String environment;
    /**专题分类id*/
    @TableField(exist = false)
    private String typeId;
    /**数据范围（是否是全库） - 采集库全库-1，企业库全库-2，政策库全库-3*/
    @TableField(updateStrategy = FieldStrategy.IGNORED) // 忽略更新策略
    private String dataScope;

}
