package com.zzsn.event.vo;

import com.zzsn.event.vo.es.Label;
import lombok.Data;

import java.util.List;

@Data
public class InfoDataSearchCondition {

    //专题id/专题分类id
    private String subjectId;

    //搜索时，全部情况下，，搜索传值
    private String search;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //发布时间
    private String publishDate;

    //来源
    private String origin;

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    /*-----------------单个专题时，起效-----------*/
    //专题配置的开始时间
    private String configStartTime;
    //专题配置的结束时间
    private String configEndTime;
    /*-----------------单个专题时，起效-----------*/

    //专题库类型(对应字典编码为【Thematic_Library】的数据字典值)
    private List<Integer> classificationType;

    /**原创性(0-非原创;1-原创;2-疑似)*/
    private String originality;

    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;

    //删除标记(1:删除；0:保留)
    private Integer deleteFlag = 0;

    //关联标签名称
    private String labelName;

    //是否专题下所有信息源(1-是;0-否)
    private String isAll;

    //专题分类(1-专题;2-事件)
    private Integer category;
    //是否视频 "video"
    private String video;
    //subjectId是否专题id(1-是;0-否)
    private String isSubject = "1";
    //爬虫类型
    private String crawler;
    /**----企业类标签筛选----**/
    //企业类标签id集合
    private List<String> enterpriseLabelTypeIds;
    //企业信用代码集合
    private List<String> socialCreditCodeList;
    /**----企业类标签id集合----**/
    //关联标签值id集合
    private List<String> labelIds;
    //正负面标签
    private String tendencyLabelId;
    //地域标签id集合
    private List<String> areaLabelIds;
    //关联信息源标签集合
    private List<Label> labelList;
    //信息源id
    private String sourceId;
    //搜索词信息集合-研究中心
    private List<SearchWordVO> searchWordList;

    //数据集id，保存数据集时使用-研究中心
    private String dataSetId;


    //关键词信息；推荐信息源时使用-研究中心
    private List<String> wordsList;


    //是否免审核(1-是;0-否)
    private Integer isFreeCheck;

    //得分范围-研究中心
    //最小得分
    private Integer minScore;
    //最大得分
    private Integer maxScore;

    //es查询字段数组
    private String[] fetchFields;

    //排序参数
    //排序字段
    private String column = "publishDate";
    //排序方式 asc/desc
    private String order = "desc";
    //置顶排序是否起效(1-是;0-否)
    private Integer topSortValid = 0;

    //分页参数
    //当前页
    private Integer pageNo = 1;
    //每页返回条数
    private Integer pageSize = 10;

    //选择前num条数据
    private Integer num;

    //资讯id集合-研究中心
    private List<String> ids;

    //关联标签名称
    private String labelMark;

    /*------资讯导出类参数-研究中心---start-------------------*/
    //导出方式(1-摘要;2-正文)
    private Integer exportType;
    /*------资讯导出类参数---end-------------------*/


    /*------专题分析类参数---start-------------------*/
    //聚合分组类型-按日期集合分析时使用
    private String groupType;
    //信息源id集合-统计分析资讯量最多的信息源时使用
    private List<String> sourceIdList;
    //聚合包含的字段值的集合
    private String[] includeValues;
    //聚合排除的字段值的集合
    private String[] excludeValues;
    /*------专题分析类参数---end-------------------*/
}
