package com.zzsn.event.config;

import com.zzsn.event.service.IEventService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class TaskExecutor implements CommandLineRunner {
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final Integer PERIOD=1;

    @Autowired
    private IEventService  eventService;
    @Override
    public void run(String... args)throws Exception {
        scheduledExecutorService.scheduleAtFixedRate(()->{
            eventService.compute();
        },5,PERIOD, TimeUnit.SECONDS);

        log.info("简易版定时任务启动成功！{}{}执行一次",PERIOD,TimeUnit.HOURS);
    }
}
