package com.zzsn.event.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.Event;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.util.ObjectUtil;
import com.zzsn.event.util.RestUtil;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.vo.Result;
import com.zzsn.event.vo.SubjectKeywordsMap;
import com.zzsn.event.vo.SubjectPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import netscape.javascript.JSObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;

 /**
 * 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Slf4j
@Api(tags="事件")
@RestController
@RequestMapping("/event/event")
public class EventController  {
	@Autowired
	private IEventService eventService;
	 @Value(("${enterprise-service.url:}"))
	 private String ENTERPRISE_URL;
	
	/**
	 * 分页列表查询
	 *
	 * @param event
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@ApiOperation(value="事件-分页列表查询", notes="事件-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(Event event,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<Event> queryWrapper = new QueryWrapper<>();
		Page<Event> page = new Page<Event>(pageNo, pageSize);
		IPage<Event> pageList = eventService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 * 添加
	 *
	 * @param event
	 * @return
	 */
	@ApiOperation(value="事件-添加", notes="事件-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody Event event) {
		eventService.save(event);
		return Result.OK("添加成功！");
	}
	
	/**
	 * 编辑
	 *
	 * @param event
	 * @return
	 */
	@ApiOperation(value="事件-编辑", notes="事件-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody Event event) {
		eventService.updateById(event);
		return Result.OK("编辑成功!");
	}
	
	/**
	 * 通过id删除
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件-通过id删除", notes="事件-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		eventService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 * 批量删除
	 *
	 * @param ids
	 * @return
	 */
	@ApiOperation(value="事件-批量删除", notes="事件-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.eventService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@ApiOperation(value="事件-通过id查询", notes="事件-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		Event event = eventService.getById(id);
		return Result.OK(event);
	}


	 /**
	  * 专题信息源绑定
	  */
	 @PostMapping("/infoSourceBind")
	 public Object infoSourceBind(@RequestBody SubjectPage subjectPage) {
		 try {
			 JSONObject params =  ObjectUtil.objectToJSONObject(subjectPage);;
			 String url = ENTERPRISE_URL + "enterpriseData/getYearReportList";
			 return RestUtil.post(url, null, params);
		 } catch (Exception e) {
			 return null;
		 }
	 }
	 /**
	  * 查询信息源组的绑定列表
	  *
	  */
	 @GetMapping("/bindList")
	 public Object bindList(InfoSourceVo infoSourceVo,
							@RequestParam(name="ynBind") Integer ynBind,
							@RequestParam(name="groupId") String groupId,
							@RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
							@RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
		 String url = ENTERPRISE_URL + "event/infoSource/bindList";
		 JSONObject params = ObjectUtil.objectToJSONObject(infoSourceVo);
		 params.put("ynBind",ynBind);
		 params.put("groupId",groupId);
		 params.put("pageNo",pageNo);
		 params.put("pageSize",pageSize);
		 return RestUtil.get(url, params);
	 }
	 /**
	  * 关键词类别
	  *
	  */
	 @GetMapping("/keywordsType/rootListNoPage")
	 public Object keywordsList(@RequestParam(name = "contain", defaultValue = "false") Boolean contain,
								@RequestParam(name = "subjectId", defaultValue = "0") String subjectId) {
		 String url = ENTERPRISE_URL + "event/keywordsType/rootListNoPage";
		 JSONObject params = new JSONObject();
		 params.put("contain",contain);
		 params.put("subjectId",subjectId);
		 return RestUtil.get(url, params);
	 }
	 /**
	  * 专题关键词绑定
	  */
	 @PostMapping("/keyWordsBind")
	 public Object keyWordsBind(@RequestBody SubjectPage subjectPage) {
		 try {
			 JSONObject params =  ObjectUtil.objectToJSONObject(subjectPage);;
			 String url = ENTERPRISE_URL + "event/keyWordsBind";
			 return RestUtil.post(url, null, params);
		 } catch (Exception e) {
			 return null;
		 }
	 }
	 /**
	  * 专题关键词绑定
	  */
	 @PostMapping("/keyWordsEdit")
	 public Object keyWordsEdit(@RequestBody SubjectKeywordsMap subjectKeywordsMap) {
		 try {
			 JSONObject params =  ObjectUtil.objectToJSONObject(subjectKeywordsMap);;
			 String url = ENTERPRISE_URL + "event/keyWords/edit";
			 return RestUtil.post(url, null, params);
		 } catch (Exception e) {
			 return null;
		 }
	 }
}
