package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 专题-信息源绑定中间表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Data
@TableName("subject_info_source_middle_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class SubjectInfoSourceMiddleMap implements Serializable {

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**专题id*/
    @TableField("subject_id")
    private String subjectId;
	/**信息源id*/
    @TableField("info_source_id")
    private String infoSourceId;
	/**信息源名称*/
    @TableField("info_source_name")
    private String infoSourceName;
	/**网址*/
    @TableField("url")
    private String url;
	/**状态(1-已有;0-待配置)*/
    @TableField("status")
    private Integer status;
    /**创建时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
    /**创建人*/
    @TableField("create_by")
    private String createBy;
}
