package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 下载中心
 * @Author: lkg
 * @Date:   2024-07-08
 */
@Data
@TableName("clb_file_download_center")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FileDownloadCenter implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**关联id*/
    private String relationId;
	/**下载内容(名称)*/
    private String name;
	/**文件路径*/
    private String filePath;
	/**文件大小*/
    private String fileSize;
	/**文件生成状态(0-生成中;1-已完成;2-异常)*/
    private Integer buildStatus;
    /**提交时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date commitTime;
	/**提交人*/
    private String commitBy;
    /**是否已读(0-否;1-是)*/
    private Integer readStatus;
    /**数据类别(1-采集库;2-专题库)*/
    private Integer category;
    /**关联id类别(1-专题;2-采集器;3-来源媒体)*/
    private Integer type;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

}
