package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.zzsn.event.mapper.SubjectKeywordsMapMapper;
import com.zzsn.event.service.ISubjectKeywordsMapService;
import com.zzsn.clb.common.model.task.dto.titr.KeyWordsDTO;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.SubjectKeywordsMap;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Description: 专题关键词关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Service
public class SubjectKeywordsMapServiceImpl extends ServiceImpl<SubjectKeywordsMapMapper, SubjectKeywordsMap> implements ISubjectKeywordsMapService {

    @Override
    @Transactional
    public void delete(String subjectId){
        baseMapper.deleteBySubjectId(subjectId);
    }
    @Override
    public KeyWordsDTO selectMinByKeyWordsId(String keyWordsId){
        return baseMapper.selectMinByKeyWordsId(keyWordsId);
    }

    @Override
    public int selectCountByKeyWordsId(String keyWordsId){
        return baseMapper.selectCountByKeyWordsId(keyWordsId);
    }

    @Override
    public KeyWordsDTO selectMaxByKeyWordsId(String keyWordsId){
        return baseMapper.selectMaxByKeyWordsId(keyWordsId);
    }

    @Override
    public List<KeyWordsPage> bindKeyWordsList(String subjectId) {
        return baseMapper.bindKeyWordsList(subjectId);
    }
}
