package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.entity.InfoSource;

import java.util.List;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date: 2022-01-18
 * @Version: V1.0
 */
public interface IInfoSourceService extends IService<InfoSource> {


    IPage<InfoSource> pageList(InfoSourceCondition infoSourceCondition, Integer pageNo, Integer pageSize);

    /**
     * 专题绑定信息源列表
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @param pageNo              当前页
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/5/7
     */
    IPage<InfoSourceVo> bindInfoSourceList(InfoSourceCondition infoSourceCondition, List<String> subjectIds, Integer pageNo, Integer pageSize);

    /**
     * 专题直接屏蔽的信息源列表(不包括专题屏蔽的信息源组下的信息源)
     *
     * @param infoSourceCondition 筛选条件
     * @param pageNo              当前页
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/4/30
     */
    IPage<InfoSourceVo> unBindSourcePageList(InfoSourceCondition infoSourceCondition,Integer pageNo, Integer pageSize);


    /**
     * 专题/事件绑定的信息源总数量
     *
     * @param subjectIds 专题/事件id
     * @author lkg
     * @date 2024/4/24
     */
    Integer bindSourceCount(List<String> subjectIds);
}
