package com.zzsn.event.service;

import com.zzsn.event.entity.EventAnalysisReport;
import com.baomidou.mybatisplus.extension.service.IService;

/**
* @author lenovo
* @description 针对表【event_analysis_report(事件分析报告)】的数据库操作Service
* @createDate 2024-04-12 11:13:13
*/
public interface EventAnalysisReportService extends IService<EventAnalysisReport> {

    /**
     * 新增分析报告-通过kafka
     *
     * @param eventId 事件id
     * @param filePath 文件路径
     * @author lkg
     * @date 2024/4/12
     */
    void modify(String eventId,String filePath);

    /**
     * 编辑事件报告
     *
     * @param report 分析报告信息
     * @author lkg
     * @date 2024/4/12
     */
    void edit(EventAnalysisReport report);
}
