package com.zzsn.event.controller;

import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.service.SubjectAnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 事件相关分析维护
 *
 * @author lkg
 * @date 2024/5/11
 */
@RestController
@RequestMapping("/maintenance")
public class EventMaintenanceController {

    @Autowired
    private SubjectAnalysisService subjectAnalysisService;

    /**
     * 事件脉络编辑
     *
     * @param subjectAnalysis 事件脉络信息
     * @author lkg
     * @date 2024/5/11
     */
    @PostMapping("/eventContextModify")
    public Result<?> eventContextModify(@RequestBody SubjectAnalysis subjectAnalysis){
        subjectAnalysisService.eventContextModify(subjectAnalysis);
        return Result.OK();
    }
}
