package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 事件地域关系表
 *
 * @author lkg
 * @date 2024/4/9
 */
@Data
@TableName("event_region_map")
@ApiModel(value="event_region_map对象")
public class EventRegionMap implements Serializable {

    /**主键id*/
    @TableId(value = "id",type = IdType.ASSIGN_ID)
    private String id;
    /**事件id*/
    @TableField("event_id")
    private String eventId;
    /**地域id*/
    @TableField("region_id")
    private String regionId;
    /**地域名称*/
    @TableField("top_region_id")
    private String topRegionId;
    /**地域类型(1-国际;2-国内)*/
    @TableField("type")
    private Integer type;
    /**创建时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
}
