package com.zzsn.event.service.impl;


import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class CaiJiCenterHttpService {

    @Value("${caiji.infosourcebind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/infoSourceEdit}")
    private String infosourcebindUrl;
    @Value("${caiji.keyWordsbind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/keywordEdit}")
    private String keyWordsbindUrl;
    @Value("${caiji.keyWordsEdit.url:http://1.95.79.85:8823/baseSourceInfo/api/keyword/edit}")
    private String keyWordsEditUrl;
    @Value("${caiji.allInfosourcebind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/infoSourceSave}")
    private String allInfosourcebindUrl;
    @Value("${caiji.allKeyWordsBind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/keywordSave}")
    private String allKeyWordsBindUrl;
    @Value("${caiji.subjectStatusEditUrl.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/editEnable}")
    private String subjectStatusEditUrl;
    @Value("${caiji.delSubjectUrl.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/delSubject}")
    private String delSubjectUrl;
    @Value("${caiji.subjectEnterpriseSource.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/saveCompanyData}")
    private String subjectEnterpriseSourceUrl;


    @Value("${caiji.projectCode:zzsn_test}")
    private String projectCode;
    @Value("${caiji.projectName:克虏宝测试}")
    private String projectName;
    @Value("${caiji.secretKey:BsEHuAQTifhnMBDni5xjTMkThpmWlNWR3vvYp1rPstQGbE6nmfBX9VhpwrBPWxrU}")
    private String secretKey;


    public String getProjectCode() {
        return projectCode;
    }

    public String getProjectName() {
        return projectName;
    }


    public String infosourcebindUrl(String jsonBody) {
        HttpRequest post = post(infosourcebindUrl,jsonBody);
        return post.execute().body();
    }

    public String keyWordsbindUrl(String jsonBody) {
        HttpRequest post = post(keyWordsbindUrl,jsonBody);
        return post.execute().body();
    }

    /**专题关键词配置通知采集*/
    public String allKeyWordsBindUrl(String jsonBody) {
        log.info("专题关键词配置通知采集{}-{}",allKeyWordsBindUrl,jsonBody);
        HttpRequest post = post(allKeyWordsBindUrl,jsonBody);
        return post.execute().body();
    }
    /**专题信息源配置通知采集*/
    public String allInfosourcebindUrl(String jsonBody) {
        log.info("专题信息源配置通知采集{}-{}",allInfosourcebindUrl,jsonBody);
        HttpRequest post = post(allInfosourcebindUrl,jsonBody);
        return post.execute().body();
    }


    /**编辑关键词通知采集*/
    public String keyWordsEditUrl(Map<String,Object> map) {
        log.info("编辑关键词通知采集{}-{}",keyWordsEditUrl,JSONUtil.toJsonStr(map));
        HttpRequest post = post(keyWordsEditUrl,map);
        return post.execute().body();
    }

    /**专题状态通知采集平台*/
    public String subjectStatusEdit(Integer status,String subjectId) {
        Map<String, Object> map = new HashMap<>();
        if (status == 1){
            //启用
            map.put("subjectSign",subjectId);
            map.put("status",0);
        }else {
            //禁用
            map.put("subjectSign",subjectId);
            map.put("status",1);
        }
        log.info("专题状态通知采集平台{}-{}",subjectStatusEditUrl,JSONUtil.toJsonStr(map));

        HttpRequest get = get(subjectStatusEditUrl,map);
        return get.execute().body();
    }
    /**专题删除通知采集平台*/
    public String delSubject(String subjectId) {
        Map<String, Object> map = new HashMap<>();
        map.put("subjectSign",subjectId);
        log.info("专题删除通知采集平台{}-{}",delSubjectUrl,JSONUtil.toJsonStr(map));
        HttpRequest get = get(delSubjectUrl,map);
        return get.execute().body();
    }
    /**专题企业来源数据配置通知采集*/
    public String subjectEnterpriseSource(Map<String,Object> map) {
        log.info("专题企业来源数据配置通知采集{}",subjectEnterpriseSourceUrl);
        HttpRequest post = post(subjectEnterpriseSourceUrl,map);
        return post.execute().body();
    }

    private HttpRequest get(String url,Map<String, Object> map) {
        HttpRequest get = HttpUtil.createGet(url);
        get.header("Content-Type", "application/json");
        get.header("authkey", secretKey);
        if (ObjectUtil.isNotEmpty(map)) {
            get.form(map);
        }
        get.timeout(120000);
        return get;
    }


    private HttpRequest post(String url,Map<String, Object> map) {
        HttpRequest post = HttpUtil.createPost(url);
        post.header("Content-Type", "application/json");
        post.header("authkey", secretKey);
        if (ObjectUtil.isNotEmpty(map)) {
            post.body(JSONUtil.toJsonStr(map));
        }
        post.timeout(120000);
        return post;
    }
    private HttpRequest post(String url,String jsonBody) {
        HttpRequest post = HttpUtil.createPost(url);
        post.header("Content-Type", "application/json");
        post.header("authkey", secretKey);
        if (StrUtil.isNotEmpty(jsonBody)) {
            post.body(jsonBody);
        }
        post.timeout(120000);
        return post;
    }

}
