package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.vo.EventExtractVO;
import com.zzsn.event.vo.EventFrontVO;

/**
 * @author lenovo
 * @description 针对表【event_extract(事件)】的数据库操作Service
 * @createDate 2024-09-07 18:00:28
 */
public interface EventExtractService extends IService<EventExtract> {

    /**
     * 伪事件信息分页列表
     *
     * @param taskId      任务id
     * @param searchWord  搜索词
     * @param eventName   事件名称
     * @param eventType   时间分类
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @param checkStatus 审核状态(2-不通过;1-通过;0-待审核)
     * @param column      排序字段
     * @param sortType    排序方式
     * @param pageNo      偏移量
     * @param pageSize    返回条数
     * @author lkg
     * @date 2024/9/9
     */
    IPage<EventExtractVO> pageList(String taskId, String searchWord, String eventName, String startTime, String endTime,
                                   String eventType, Integer checkStatus, String column, String sortType, Integer pageNo, Integer pageSize);
    /**
     * 自动追踪事件分页列表-门户
     *
     * @param projectId    项目id
     * @param eventName   事件名称
     * @param eventType   时间分类
     * @param pageNo      偏移量
     * @param pageSize    返回条数
     * @author lkg
     * @date 2024/9/9
     */
    IPage<EventFrontVO> frontPageList(String projectId, String eventName, String eventType, Integer pageNo, Integer pageSize);
}
