package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventExtract;
import com.zzsn.event.service.EventExtractService;
import com.zzsn.event.mapper.EventExtractMapper;
import com.zzsn.event.service.IEventCategoryService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.EventExtractVO;
import com.zzsn.event.vo.EventFrontVO;
import com.zzsn.event.vo.EventManageVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_extract(事件)】的数据库操作Service实现
 * @createDate 2024-09-07 18:00:28
 */
@Service
public class EventExtractServiceImpl extends ServiceImpl<EventExtractMapper, EventExtract> implements EventExtractService {

    @Autowired
    private IEventCategoryService eventCategoryService;

    @Override
    public IPage<EventExtractVO> pageList(String taskId, String searchWord, String eventName,
                                          String startTime, String endTime, String eventType,
                                          Integer checkStatus, String column, String sortType, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        List<EventExtractVO> pageList = baseMapper.pageList(taskId, searchWord, eventName, startTime, endTime, eventType, checkStatus, column, sortType, offset, pageSize);
        Long totalCount = baseMapper.totalCount(taskId, searchWord, eventName, startTime, endTime, eventType, checkStatus);
        IPage<EventExtractVO> pageData = new Page<>(pageNo, pageSize, totalCount);
        pageData.setRecords(pageList);
        return pageData;
    }

    @Override
    public IPage<EventFrontVO> frontPageList(String projectId, String eventName, String eventType, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        List<String> eventTypes = new ArrayList<>();
        if (StringUtils.isNotEmpty(eventType)) {
            List<Node> nodes = eventCategoryService.categoryList();
            eventTypes = TreeUtil.belowList(nodes, eventType, true);
        }
        List<EventFrontVO> pageList = baseMapper.frontPageList(projectId, eventName, eventTypes, offset, pageSize);
        Long count = baseMapper.frontTotalCount(projectId, eventName, eventTypes);
        IPage<EventFrontVO> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }
}




