package com.zzsn.event.service;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectInfoSourceMap;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectStatisticsVo;


import java.util.List;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
public interface ISubjectInfoSourceMapService extends IService<SubjectInfoSourceMap> {

    /**
     * 根据专题id删除关联数据
     */
    void delete(String subjectId);

    /**
     * 更新数据
     * @param subjectInfoSourceMap
     */
    void updateMain(SubjectInfoSourceMap subjectInfoSourceMap);

    /**
     *  绑定信息源
     *
     * @param subjectPage 参数信息
     * @author lkg
     * @date 2024/12/17
     */
    void infoSourceBind(SubjectPage subjectPage);

    /**
     * 删除信息源组的绑定
     *
     * @param subjectPage 参数
     * @author lkg
     * @date 2024/12/18
     */
    void deleteBind(SubjectPage subjectPage);

    /**
     * 获取专题/事件绑定的信息源组列表
     *
     * @param id 专题/事件id
     * @author lkg
     * @date 2024/12/18
     */
    JSONObject bindInfoSource(String id);

    /**
     * 编辑专题/事件和信息源组的绑定关系
     *
     * @param infoSourceGroupPage 参数
     * @author lkg
     * @date 2024/12/18
     */
   void modifyInfoSourceInfo(InfoSourceGroupPage infoSourceGroupPage);

    /**
     * 专题真正绑定的信息源id集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> subjectRealBindInfoSourceList(List<String> subjectIds);

    /**
     * 专题真正绑定的信息源集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<SubjectStatisticsVo> subjectRealBindInfoSources(List<String> subjectIds);

    /**
     * 根据批量删除
     */
    void deleteInfoSourceIds(String subjectId, List<String> infoSourceIds, Integer type);
}
