package com.zzsn.event.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.EnumHandlerStatus;
import com.zzsn.event.enums.EnumOperateWay;
import com.zzsn.event.es.EsService;
import com.zzsn.event.service.*;
import com.zzsn.event.util.*;
import com.zzsn.event.util.user.AuthUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.*;
import com.zzsn.event.vo.es.*;
import com.zzsn.event.vo.log.DataLifecycleLog;
import com.zzsn.event.entity.InfoSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * 资讯
 *
 * @author lkg
 * @date 2024/12/19
 */
@Slf4j
@Service
public class InformationServiceImpl implements InformationService {

    @Autowired
    private EsService esService;
    @Autowired
    private EsOpUtil esOpUtil;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private IEventService eventService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private ISubjectTypeService subjectTypeService;
    @Autowired
    private ISubjectTypeMapService subjectTypeMapService;
    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private IKeyWordsService keyWordsService;
    @Autowired
    private IClbSysAttachmentService clbSysAttachmentService;
    @Autowired
    private IClbFileOperationLogService clbFileOperationLogService;
    @Autowired
    private IClbFileOperationLogDetailsService clbFileOperationLogDetailsService;
    @Autowired
    private ICollectionMapService collectionMapService;
    @Autowired
    private SysDictItemService sysDictItemService;
    @Autowired
    private IClbSysAttachmentService csAttachmentService;


    @Override
    public IPage<EventDataVO> collectPageList(InfoDataSearchCondition eventDataCondition) {
        return esService.collectPageList(eventDataCondition);
    }

    @Override
    public IPage<DisplayInfo> subjectPageList(UserVo userVo, InfoDataSearchCondition searchCondition) {
        IPage<DisplayInfo> page = new Page<>(searchCondition.getPageNo(), searchCondition.getPageSize());
        List<String> subjectIdList = new ArrayList<>();
        //判断是否是专题
        if ("1".equals(searchCondition.getIsSubject())) {
            if (StringUtils.isNotEmpty(searchCondition.getSubjectId())) {
                subjectIdList.add(searchCondition.getSubjectId());
            }
        } else {
            //该id其实是专题类别id
            //查询类别id的所有明细id
            String subjectTypeId = searchCondition.getSubjectId();
            Integer category = searchCondition.getCategory();
            List<String> typeIds = subjectTypeService.belowIdList(subjectTypeId, category);
            if (category == 1) {
                subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
            } else if (category == 2) {
                subjectIdList = subjectTypeMapService.selectEventByTypeIds(typeIds);
            }
        }
        List<String> relationIds = searchCondition.getLabelIds();
        List<String> labelTypeIds = searchCondition.getLabelTypeIds();
        if (CollectionUtils.isNotEmpty(labelTypeIds)) {
            List<String> socialCreditCodeList = commonService.codesByLabels(labelTypeIds);
            relationIds.addAll(socialCreditCodeList);
        }
        searchCondition.setLabelIds(relationIds);
        try {
            IPage<SpecialInformation> specialInformationIPage = esService.pageListByCondition(searchCondition,subjectIdList);
            long total = specialInformationIPage.getTotal();
            if (total > 0) {
                List<DisplayInfo> dataList = new ArrayList<>();
                List<LabelModelVo> labelModelVos = commonService.subjectModelBindLabels(subjectIdList);
                Map<String, List<LabelModelVo>> modelMap = labelModelVos.stream().collect(Collectors.groupingBy(LabelModelVo::getSubjectId));
                List<SpecialInformation> records = specialInformationIPage.getRecords();
                for (SpecialInformation specialInformation : records) {
                    DisplayInfo info = new DisplayInfo();
                    BeanUtils.copyProperties(specialInformation,info);
                    info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
                    /*LambdaQueryWrapper<CollectionMap> query = Wrappers.lambdaQuery();
                    query.eq(CollectionMap::getUserId, userVo.getId());
                    query.eq(CollectionMap::getArticleId, info.getId());
                    int count = collectionMapService.count(query);
                    if (count > 0) {
                        info.setYnCollect(true);
                    }*/
                    //标签处理
                    List<LabelModelVo> modelVoList = modelMap.get(info.getSubjectId());
                    formatLabel(modelVoList, info);
                    dataList.add(info);
                }
                page.setRecords(dataList);
                page.setTotal(total);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return page;
    }

    @Override
    public DisplayInfo queryInfo(Integer type,String index, String id) {
        DisplayInfo info = (DisplayInfo) esOpUtil.getInfoById(index, id, DisplayInfo.class);
        info.setDbIndex(index);
        if (StringUtils.isNotEmpty(info.getContentWithTag())) {
            String contentNoTag = Utility.TransferHTML2TextWithImg(info.getContentWithTag());
            String contentNoTag2 = Utility.dealImg(contentNoTag);
            info.setContent(contentNoTag2);
        }
        info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
        if (type == 2) {
            //获取附件信息
            if (info.getAttachmentIds() != null && info.getAttachmentIds().size() > 0) {
                List<AttachmentInfo> attachmentInfoList = new ArrayList<>();
                for (String attachmentId : info.getAttachmentIds()) {
                    QueryWrapper<ClbSysAttachment> queryWrapper = Wrappers.query();
                    queryWrapper.eq("id", attachmentId);
                    ClbSysAttachment clbSysAttachment = clbSysAttachmentService.getOne(queryWrapper);
                    if (clbSysAttachment != null) {
                        AttachmentInfo attachmentInfo = new AttachmentInfo();
                        attachmentInfo.setAttachmentName(clbSysAttachment.getName());
                        attachmentInfo.setAttachmentPath(clbSysAttachment.getPath());
                        attachmentInfo.setGroup(clbSysAttachment.getGroupName());
                        attachmentInfo.setAttachmentId(String.valueOf(clbSysAttachment.getId()));
                        attachmentInfo.setAttachmentFullPath(Constants.OBS_FILE_PATH_URL_PREFIX + clbSysAttachment.getObjectKey());
                        attachmentInfo.setPageSize(clbSysAttachment.getPageSize());
                        attachmentInfo.setSource(clbSysAttachment.getSource());
                        attachmentInfo.setFileSize(clbSysAttachment.getFileSize());
                        attachmentInfoList.add(attachmentInfo);
                    }
                }
                info.setAttachmentInfos(attachmentInfoList);
                info.setYnArticle(false);
            }

            CompletableFuture.runAsync(()->  addReadNum(info, index));
        }
        return info;
    }

    @Override
    public void saveAsDataSet(InfoDataSearchCondition searchCondition) {
        String[] fetchFields = new String[]{"id", "labels"};
        searchCondition.setFetchFields(fetchFields);
        searchCondition.setPageSize(300);
        Label dataSet = new Label();
        String dataSetId = searchCondition.getDataSetId();
        dataSet.setRelationId(dataSetId);
        Map<String,List<SpecialInformation>> map = new HashMap<>();
        for (int i = 1; ; i++) {
            searchCondition.setPageNo(i);
            List<SpecialInformation> informationList = esService.informationList(searchCondition);
            log.info("保存数据集：本次循环-{}，数据量为-{}", i, informationList.size());
            if (CollectionUtils.isEmpty(informationList)) {
                break;
            }
            for (SpecialInformation information : informationList) {
                String index = information.getDbIndex();
                List<Label> labels = information.getLabels();
                if (CollectionUtils.isNotEmpty(labels)) {
                    boolean present = labels.stream().anyMatch(label -> label.getRelationId().equals(dataSetId));
                    if (!present) {
                        labels.add(dataSet);
                    }
                } else {
                    labels.add(dataSet);
                }
                information.setLabels(labels);
                if (map.containsKey(index)) {
                    map.get(index).add(information);
                } else {
                    List<SpecialInformation> list = new ArrayList<>();
                    list.add(information);
                    map.put(index, list);
                }
            }
        }
        map.forEach((k, v) -> esOpUtil.docUpdateBulk(k, v));
    }

    @Override
    public List<List<String>> statisticsExportList(String subjectId, String startDate, String endDate) {
        List<String> subjectIdList = new ArrayList<>();
        //查询类别id的所有明细id
        if (!"0".equals(subjectId)) {
            List<String> typeIds = subjectTypeService.belowIdList(subjectId, 1);
            subjectIdList = subjectTypeMapService.selectSubjectByTypeIds(typeIds);
        }
        subjectIdList.add(subjectId);
        //专题关联的信息源集合
        List<SubjectStatisticsVo> infoSourceList = subjectInfoSourceMapService.subjectRealBindInfoSources(subjectIdList);
        List<String> dateList = DateUtil.betweenDate(startDate, endDate);
        List<List<String>> dataList = new ArrayList<>();
        Map<String, Map<String, Long>> stringMapMap = esService.regetFromEs(infoSourceList.stream().map(SubjectStatisticsVo::getId).collect(Collectors.toList()), startDate, endDate);
        //封装导出excel需要的数据集合
        for (SubjectStatisticsVo subjectStatisticsVo : infoSourceList) {
            Map<String, Long> stringLongMap = stringMapMap.get(subjectStatisticsVo.getId());
            List<SubjectStatisticsVo> value = new ArrayList<>();
            int sum = 0;
            if (null != stringLongMap) {
                for (Map.Entry<String, Long> entry : stringLongMap.entrySet()) {
                    String date = entry.getKey();
                    Long count = entry.getValue();
                    SubjectStatisticsVo subjectStatisticsVoTemp = new SubjectStatisticsVo();
                    subjectStatisticsVoTemp.setId(subjectStatisticsVo.getId());
                    subjectStatisticsVoTemp.setSiteName(subjectStatisticsVo.getSiteName());
                    subjectStatisticsVoTemp.setDate(date);
                    int num = Math.toIntExact(count);
                    subjectStatisticsVoTemp.setCollectCount(num);
                    value.add(subjectStatisticsVoTemp);
                    sum += Math.toIntExact(count);
                }
            }
            List<String> list = subjectStatisticsVo.toExcelList();
            //信息源在时间段内的采集总量
            list.add(String.valueOf(sum));
            //信息源采集到数据的日期集合
            Set<String> collectDates = value.stream().collect(Collectors.groupingBy(SubjectStatisticsVo::getDate)).keySet();
            //信息源未采集到数据的日期集合
            List<String> noCollectDates = new ArrayList<>(dateList);
            noCollectDates.removeAll(collectDates);
            for (String date : noCollectDates) {
                SubjectStatisticsVo vo = new SubjectStatisticsVo();
                BeanUtils.copyProperties(subjectStatisticsVo, vo);
                vo.setCollectCount(0);
                vo.setDate(date);
                value.add(vo);
            }
            //根据采集时间排序(正序)
            value.sort(Comparator.comparing(SubjectStatisticsVo::getDate));
            value.forEach(e -> list.add(String.valueOf(e.getCollectCount())));
            dataList.add(list);
        }
        return dataList;
    }

    @Override
    public void manualAdd(List<ManualAddVO> manualAddVOs) {
        for (ManualAddVO manualAddVO : manualAddVOs) {
            try {
                String id = manualAddVO.getId();
                String subjectId = manualAddVO.getSubjectId();
                String subjectName = manualAddVO.getSubjectName();
                String index = manualAddVO.getIndex();
                SpecialInformation subjectdatabase = (SpecialInformation) esOpUtil.getInfoById(index, id, SpecialInformation.class);
                String dataId = subjectId + id;
                subjectdatabase.setId(dataId);
                subjectdatabase.setProcessDate(DateUtil.dateToString(new Date(), "yyyy-MM-dd'T'HH:mm:ss"));
                subjectdatabase.setSubjectId(subjectId);
                subjectdatabase.setSubjectName(subjectName);
                subjectdatabase.setDeleteFlag(0);
                subjectdatabase.setCheckStatus(0);
                subjectdatabase.setTopNum(0);
                esOpUtil.docSaveByJson(Constants.SUBJECT_INDEX + "_" + LocalDateTime.now().getYear(), dataId, JSON.toJSONString(subjectdatabase));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean duplicationByTitleOrSourceAddress(DisplayInfo displayInfo) {
        return esService.duplicationByTitleOrSourceAddress(displayInfo);
    }

    @Override
    public void add(DisplayInfo displayInfo,Integer category, UserVo userVo) {
        SpecialInformation specialInformation = new SpecialInformation();
        BeanUtils.copyProperties(displayInfo, specialInformation);
        String id = specialInformation.getSubjectId() + codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8);
        specialInformation.setId(id);
        specialInformation.setUniqueCode(id);
        specialInformation.setDeleteFlag(0);
        specialInformation.setCheckStatus(0);
        specialInformation.setTopNum(0);
        specialInformation.setFlag("1");
        specialInformation.setCreateDate(EsDateUtil.esFieldDateFormat(cn.hutool.core.date.DateUtil.formatDateTime(new Date())));
        specialInformation.setProcessDate(EsDateUtil.esFieldDateFormat(cn.hutool.core.date.DateUtil.formatDateTime(new Date())));
        specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(specialInformation.getPublishDate()));
        specialInformation.setMasterEntryId(specialInformation.getId());
        if (displayInfo.getYnArticle()) {
            //加上分类
            setInfoSourceType(specialInformation);
        }
        //用户信息
        String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
        //检查是否有附件信息
        if (ObjectUtils.isNotEmpty(specialInformation.getAttachmentInfos())) {

            specialInformation.getAttachmentInfos().forEach(e -> {
                ClbSysAttachment attachmentInfo = new ClbSysAttachment();
                attachmentInfo.setTypeId("6");
                attachmentInfo.setName(e.getAttachmentName());
                attachmentInfo.setGroupName(e.getGroup());
                attachmentInfo.setPath(e.getAttachmentPath());
                attachmentInfo.setFullPath(e.getAttachmentFullPath());
                attachmentInfo.setCategory(e.getCategory());
                attachmentInfo.setFileSize(e.getFileSize());
                attachmentInfo.setItemId(specialInformation.getId());
                attachmentInfo.setStatus(1);
                attachmentInfo.setOrderBy(0);
                attachmentInfo.setSource("");
                attachmentInfo.setYear(cn.hutool.core.date.DateUtil.thisYear());
                clbSysAttachmentService.save(attachmentInfo);
                e.setAttachmentId(attachmentInfo.getId().toString());
            });
        }
        String index = EsIndexUtil.getIndexYear(Constants.SUBJECT_INDEX);
        esOpUtil.docSavaByEntity(index, specialInformation.getId(), specialInformation);
        // 发送数据生命周期日志  入专题库 新增消息到kafka
        final Subjectdatabase subjectdatabase = new Subjectdatabase();
        BeanUtil.copyProperties(specialInformation, subjectdatabase, CopyOptions.create().ignoreError().ignoreNullValue());
        String subjectName = subjectdatabase.getSubjectName();
        if (StringUtils.isEmpty(subjectName)) {
            String subjectId = subjectdatabase.getSubjectId();
            if (category == 1) {
                Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                        .eq(Subject::getId, subjectId)
                        .select(Subject::getSubjectName));
                subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
            } else if (category == 2) {
                Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                        .eq(Event::getId, subjectId)
                        .select(Event::getEventName));
                subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
            }
            subjectdatabase.setSubjectName(subjectName);
        }

        final DataLifecycleLog toSubjectLog = DataLifecycleLog.createToSubjectLog(subjectdatabase, operateUser);
        kafkaTemplate.send("data_lifecycle_log_to_subject", JSONUtil.toJsonStr(toSubjectLog));
    }

    @Override
    public void updateInfo(JSONObject jsonObject,UserVo userVo) {
        SpecialInformation specialInformation = JSON.parseObject(JSON.toJSONString(jsonObject.get("data")), SpecialInformation.class);
        Integer category = (Integer) jsonObject.get("category");
        String index = specialInformation.getDbIndex();
        specialInformation.setIndex(null);
        //更新content字段
        if (StringUtils.isNotBlank(specialInformation.getContentWithTag())) {
            String content = Jsoup.parse(specialInformation.getContentWithTag()).text();
            specialInformation.setContent(content);
        }
        if (StringUtils.isNotBlank(specialInformation.getContentWithTagRaw())) {
            String contentRaw = Jsoup.parse(specialInformation.getContentWithTagRaw()).text();
            specialInformation.setContentRaw(contentRaw);
        }
        //处理时间格式
        specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(specialInformation.getPublishDate()));
        specialInformation.setCreateDate(EsDateUtil.esFieldDateFormat(specialInformation.getCreateDate()));
        specialInformation.setUpdateDate(EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date())));
        ESData esData = new ESData();
        BeanUtil.copyProperties(specialInformation, esData);
        esOpUtil.docUpdateById(index, specialInformation.getId(), JSON.toJSONString(esData));
        //修改信息源的原创新
        if (StringUtils.isNotBlank(specialInformation.getOriginalSource())) {
            infoSourceService.update(Wrappers.<InfoSource>lambdaUpdate().eq(InfoSource::getId,specialInformation.getSid())
                    .set(InfoSource::getOriginalSource,specialInformation.getOriginalSource()));
        }
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> sendManualKafkaMsg(category,specialInformation, EnumOperateWay.EDITED, null,userVo));
    }

    @Override
    public void checkInfo(Map<String, Object> map, UserVo userVo) {
        List<Map<String, String>> ids = (List<Map<String, String>>) map.get("ids");
        Integer checkStatus = (Integer) map.get("checkStatus");
        Integer category = (Integer) map.get("category");
        for (Map<String, String> m : ids) {
            String index = m.get("index");
            String id = m.get("id");
            Map<String,Object> updateFields = new HashMap<>();
            updateFields.put("checkStatus",checkStatus);
            updateFields.put("deleteFlag",0);
            String operateDate = EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()));
            updateFields.put("updateDate", operateDate);
            updateFields.put("checkDate", operateDate);
            esOpUtil.updateById(index, id, updateFields);
            // 发送生命周期日志到kafka
            CompletableFuture.runAsync(() -> {
                final DataLifecycleLog dataCheckLog;
                final Subjectdatabase subjectdatabase = (Subjectdatabase) esOpUtil.getInfoById(index, id, Subjectdatabase.class);
                String subjectName = subjectdatabase.getSubjectName();
                if (StringUtils.isEmpty(subjectName)) {
                    String subjectId = subjectdatabase.getSubjectId();
                    if (category == 1) {
                        Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                                .eq(Subject::getId, subjectId)
                                .select(Subject::getSubjectName));
                        subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
                    } else if (category == 2) {
                        Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                                .eq(Event::getId, subjectId)
                                .select(Event::getEventName));
                        subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
                    }
                    subjectdatabase.setSubjectName(subjectName);
                }
                String sourceName;
                final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                        .eq("id", subjectdatabase.getSid())
                        .select("site_name"));
                if (infoSource == null) {
                    sourceName = Optional.ofNullable(
                                    keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                            .eq("id", subjectdatabase.getSid())
                                            .select("words_name")))
                            .orElse(new KeyWords())
                            .getWordsName();
                } else {
                    sourceName = infoSource.getWebSiteName();
                }
                final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
                if (checkStatus == 1) {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.RETAINED);
                } else if (checkStatus == 0) {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.RETAIN_CANCELED);
                } else {
                    dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.TEMPORARY);
                }
                kafkaTemplate.send("data_lifecycle_log_data_check", JSONUtil.toJsonStr(dataCheckLog));
            });
        }
    }

    @Override
    public void deleteBatch(Map<String, Object> map, UserVo userVo) {
        List<Map<String, String>> ids = (List<Map<String, String>>) map.get("ids");
        Integer deleteFlag = (Integer) map.get("deleteFlag");
        Integer category = (Integer) map.get("category");
        for (Map<String, String> m : ids) {
            String index = m.get("index");
            String id = m.get("id");
            Map<String,Object> updateFields = new HashMap<>();
            updateFields.put("checkStatus",0);
            updateFields.put("deleteFlag",deleteFlag);
            String operateDate = EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()));
            updateFields.put("updateDate", operateDate);
            updateFields.put("checkDate", operateDate);
            esOpUtil.updateById(index, id, updateFields);
            // 发送生命周期日志到kafka
            CompletableFuture.runAsync(() -> {
                final DataLifecycleLog dataCheckLog;
                final Subjectdatabase subjectdatabase = (Subjectdatabase) esOpUtil.getInfoById(index, id, Subjectdatabase.class);
                String subjectName = subjectdatabase.getSubjectName();
                if (StringUtils.isEmpty(subjectName)) {
                    String subjectId = subjectdatabase.getSubjectId();
                    if (category == 1) {
                        Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                                .eq(Subject::getId, subjectId)
                                .select(Subject::getSubjectName));
                        subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
                    } else if (category == 2) {
                        Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                                .eq(Event::getId, subjectId)
                                .select(Event::getEventName));
                        subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
                    }
                    subjectdatabase.setSubjectName(subjectName);
                }
                String sourceName;
                final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                        .eq("id", subjectdatabase.getSid())
                        .select("site_name"));
                if (infoSource == null) {
                    sourceName = Optional.ofNullable(
                                    keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                            .eq("id", subjectdatabase.getSid())
                                            .select("words_name")))
                            .orElse(new KeyWords())
                            .getWordsName();
                } else {
                    sourceName = infoSource.getWebSiteName();
                }
                final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
                dataCheckLog = DataLifecycleLog.createDataCheckLog(subjectdatabase, operateUser, sourceName, EnumHandlerStatus.DELETED);
                kafkaTemplate.send("data_lifecycle_log_data_check", JSONUtil.toJsonStr(dataCheckLog));
            });
        }
    }

    @Override
    public void removeBatch(Map<String, Object> map) {
        ArrayList<Map<String, String>> ids = (ArrayList<Map<String, String>>) map.get("ids");
        //判断ids字段是否为空
        if (ids != null && !ids.isEmpty()) {
            esOpUtil.docRemoveBulk(ids);
        }
    }

    @Override
    public void topInfo(SubjectInfoVo subjectInfoVo,UserVo userVo) {
        Integer category = subjectInfoVo.getCategory();
        String index = subjectInfoVo.getIndex();
        Integer type = subjectInfoVo.getType();
        String id = subjectInfoVo.getId();
        Map<String,Object> updateFields = new HashMap<>();
        if (type == 0) {
            updateFields.put("topNum",0);
        } else {
            //先查询出库里面最大的置顶id
            int topNum = esService.getTopNum(index,subjectInfoVo.getSubjectId());
            updateFields.put("topNum",topNum + 1);
        }
        esOpUtil.updateById(index, id, updateFields);
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> {
            SpecialInformation specialInformation = (SpecialInformation) esOpUtil.getInfoById(index, subjectInfoVo.getId(), SpecialInformation.class);
            if (type == 0) {
                sendManualKafkaMsg(category,specialInformation, EnumOperateWay.TOP_CANCELED, null,userVo);
            } else {
                sendManualKafkaMsg(category,specialInformation, EnumOperateWay.TOP, null,userVo);
            }
        });
    }

    @Override
    public void collect(CollectionInfo collectionInfo) {
        UserVo userVo = UserUtil.getLoginUser();
        String userId = userVo.getId();
        CollectionMap collectionMap = new CollectionMap();
        BeanUtils.copyProperties(collectionInfo, collectionMap);
        collectionMap.setUserId(userId);
        String type = collectionInfo.getType();
        if ("1".equals(type)) {
            collectionMap.setEsIndex(collectionInfo.getIndex());
            collectionMapService.save(collectionMap);
        } else {
            QueryWrapper<CollectionMap> query = Wrappers.query();
            query.eq("user_id", userId);
            query.eq("article_id", collectionMap.getArticleId());
            collectionMapService.remove(query);
        }
        //发送 人工操作 日志
        CompletableFuture.runAsync(() -> {
            Integer category = collectionInfo.getCategory();
            SpecialInformation specialInformation = (SpecialInformation) esOpUtil.getInfoById(collectionInfo.getIndex(), collectionInfo.getArticleId(), SpecialInformation.class);
            if ("1".equals(type)) {
                sendManualKafkaMsg(category,specialInformation, EnumOperateWay.COLLECTED, null,userVo);
            } else {
                sendManualKafkaMsg(category,specialInformation, EnumOperateWay.COLLECT_CANCELED, null,userVo);
            }
        });
    }

    @Override
    public List<StatisticsKeyWordVo> hotWords(String index, String id, Integer number) {
        SubjectDataVo subjectDataVo = esService.queryInfo(index, id);
        String content = subjectDataVo.getContent();
        List<Map.Entry<String, Integer>> keywordsList = HanlpUtil.extractKeyWordsByText(Jsoup.parse(content).text(), number);
        List<StatisticsKeyWordVo> rn = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(keywordsList)) {
            for (Map.Entry<String, Integer> entry : keywordsList) {
                StatisticsKeyWordVo statisticsKeyWordVo = new StatisticsKeyWordVo();
                statisticsKeyWordVo.setName(entry.getKey());
                statisticsKeyWordVo.setValue(entry.getValue());
                rn.add(statisticsKeyWordVo);
            }
        }
        return rn;
    }

    @Override
    public List<SubjectDataVo> recommendList(String subjectId, String id, String title, Integer pageNo, Integer pageSize) {
        return esService.queryRecommendList(subjectId,id,title,pageNo,pageSize);
    }

    //导入发布库数据
    @Override
    public void importInfo(List<List<String>> lists, String subjectId, String isTopping, String isExamine, ClbFileOperationLog clbFileOperationLog, UserVo userVo) {
        if (null == clbFileOperationLog) {
            clbFileOperationLog = clbFileOperationLogService.operationStart(userVo);
            clbFileOperationLog.setSubjectId(subjectId);
        }
        for (List<String> info : lists) {

            try {
                SpecialInformation specialInformation = new SpecialInformation();
                specialInformation.setId(codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8));
                //判断正文是否为空
                if (StringUtils.isEmpty(info.get(3))) {
                    ClbFileOperationLogDetails clbFileOperationLogDetails = clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7), "资讯内容为空");
                    clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetails);
                    continue;
                }
                if (StringUtils.isNotEmpty(info.get(0))) {
                    specialInformation.setScore(Double.valueOf(info.get(0)));
                }
                if (StringUtils.isNotEmpty(info.get(1))) {
                    specialInformation.setTitle(info.get(1));
                }
                if (StringUtils.isNotEmpty(info.get(2))) {
                    specialInformation.setSummary(info.get(2));
                }
                if (StringUtils.isNotEmpty(info.get(3))) {
                    specialInformation.setContent(info.get(3));
                }
                if (StringUtils.isNotEmpty(info.get(4))) {
                    specialInformation.setAuthor(info.get(4));
                }
                if (StringUtils.isNotEmpty(info.get(5))) {
                    specialInformation.setOrigin(info.get(5));
                }
                if (StringUtils.isNotEmpty(info.get(6))) {
                    specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(info.get(6)));
                }
                if (StringUtils.isNotEmpty(info.get(7))) {
                    specialInformation.setSourceAddress(info.get(7));
                }
                //0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例
                if (StringUtils.isNotEmpty(info.get(8))) {
                    if ("政策".equals(info.get(8))) {
                        specialInformation.setClassificationType(1);
                    } else if ("领导讲话".equals(info.get(8))) {
                        specialInformation.setClassificationType(2);
                    } else if ("专家观点".equals(info.get(8))) {
                        specialInformation.setClassificationType(3);
                    } else if ("企业案例".equals(info.get(8))) {
                        specialInformation.setClassificationType(4);
                    } else {
                        specialInformation.setClassificationType(0);
                    }
                }
                specialInformation.setDeleteFlag(0);
                specialInformation.setTopNum(0);
                specialInformation.setSubjectId(subjectId);
                specialInformation.setFlag("1");
                specialInformation.setMasterEntryId(specialInformation.getId());
                specialInformation.setDataFrom(1);
                //加上分类
                setInfoSourceType(specialInformation);
                //判断是否需要审核
                if (StringUtils.isNotEmpty(isExamine) && "false".equals(isExamine)) {
                    specialInformation.setCheckStatus(1);
                }
                //判断是否置顶
                if (StringUtils.isNotEmpty(isTopping) && "true".equals(isTopping)) {
                    int topNum = esService.getTopNum(null, subjectId);
                    specialInformation.setTopNum(topNum + 1);
                }
                specialInformation.setCreateDate(cn.hutool.core.date.DateUtil.format(new Date(), "yyyy-MM-dd'T'HH:mm:ss"));
                specialInformation.setProcessDate(specialInformation.getCreateDate());
                String index = EsIndexUtil.getIndexYear(Constants.SUBJECT_INDEX);
                esOpUtil.docSavaByEntity(index, specialInformation.getId(), specialInformation);
                clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7)));
            } catch (NumberFormatException e) {
                ClbFileOperationLogDetails clbFileOperationLogDetails = clbFileOperationLogDetailsService.buildFailDetails(info.get(1), info.get(5), info.get(7), "插入es异常" + e.getMessage());
                clbFileOperationLog.getClbFileOperationLogDetails().add(clbFileOperationLogDetails);
            }

        }
        clbFileOperationLogService.saveEntity(clbFileOperationLog);
    }

    @Override
    public void importDataInfo(List<List<String>> lists, String subjectId) {
        if (CollectionUtil.isNotEmpty(lists)) {
            String index = EsIndexUtil.getIndexYear(Constants.SUBJECT_INDEX);
            List<SpecialInformation> dataList = new ArrayList<>();
            for (List<String> info : lists) {
                SpecialInformation specialInformation = new SpecialInformation();
                specialInformation.setId(codeGenerateUtil.geneIdNo(Constants.DATA_ADD_ID, 8));
                if (StringUtils.isNotEmpty(info.get(0))) {
                    specialInformation.setTitle(info.get(0));
                }
                if (StringUtils.isNotEmpty(info.get(1))) {
                    specialInformation.setAuthor(info.get(1));
                }
                if (StringUtils.isNotEmpty(info.get(2))) {
                    specialInformation.setOrigin(info.get(2));
                    specialInformation.setSid(info.get(2));
                }
                if (StringUtils.isNotEmpty(info.get(3))) {
                    String library = info.get(3);
                    SysDictItem dictItem = sysDictItemService.dictItemInfoByName("Thematic_Library", library);
                    if (dictItem != null) {
                        specialInformation.setClassificationType(Integer.parseInt(dictItem.getItemValue()));
                    } else {
                        specialInformation.setClassificationType(0);
                    }
                } else {
                    specialInformation.setClassificationType(0);
                }
                if (StringUtils.isNotEmpty(info.get(4))) {
                    specialInformation.setSourceAddress(info.get(4));
                }
                if (StringUtils.isNotEmpty(info.get(5))) {
                    specialInformation.setPublishDate(EsDateUtil.esFieldDateFormat(info.get(5)));
                }
                if (StringUtils.isNotEmpty(info.get(6))) {
                    specialInformation.setContent(info.get(6));
                }
                specialInformation.setCheckStatus(1);
                specialInformation.setDeleteFlag(0);
                specialInformation.setTopNum(0);
                specialInformation.setDataFrom(1);
                specialInformation.setSubjectId(subjectId);
                String format = DateUtil.dateToString(new Date(), "yyyy-MM-dd'T'HH:mm:ss");
                specialInformation.setCreateDate(format);
                specialInformation.setProcessDate(format);
                //加上分类
                setInfoSourceType(specialInformation);
                //匹配标签
                List<Label> labels = getInfoSourceLabel(specialInformation.getOrigin(), specialInformation.getSourceAddress());
                specialInformation.setLabels(labels);
                dataList.add(specialInformation);
            }
            esOpUtil.docSaveBulk(index, dataList);
        }
    }


    private void formatLabel(List<LabelModelVo> labelModelVos, DisplayInfo info) {
        if (CollectionUtils.isNotEmpty(labelModelVos)) {
            List<Label> list = info.getLabels();
            List<LabelInfo> labelInfos = new ArrayList<>();
            //获取专题打的标签
            for (LabelModelVo labelModelVo : labelModelVos) {
                LabelInfo labelInfo = new LabelInfo();
                labelInfo.setLabelId(labelModelVo.getLabelId());
                labelInfo.setLabelName(labelModelVo.getLabelName());
                labelInfo.setLabelType(labelModelVo.getLabelType());
                labelInfo.setLabelMark(labelModelVo.getLabelMark());
                List<Label> labelList = new ArrayList<>();
                if (list != null && !list.isEmpty()) {
                    for (Label label : list) {
                        if (StringUtils.isNotBlank(label.getLabelMark()) &&
                                (label.getLabelMark().contains(labelModelVo.getLabelMark()) || ("company_label".equals(labelModelVo.getLabelType()) && "company_label".equals(label.getLabelRemarks())))) {
                            labelList.add(label);
                        }
                    }
                }
                labelInfo.setLabelList(labelList);
                labelInfos.add(labelInfo);
            }
            info.setLabelInfos(labelInfos);
        }
    }


    private void addReadNum(DisplayInfo displayInfo, String index) {
        if (displayInfo != null) {
            Long readNum = displayInfo.getReadNum();
            if (readNum == 0) {
                readNum = 1L;
            } else {
                readNum = readNum + 1;
            }
            Map<String,Object> updateFieldMap = new HashMap<>();
            updateFieldMap.put("readNum",readNum);
            esOpUtil.updateById(index, displayInfo.getId(), updateFieldMap);
        }
    }

    //发送 人工操作 日志
    private void sendManualKafkaMsg(Integer category,SpecialInformation specialInformation, EnumOperateWay enumOperateWay, List<String> labelNameList,UserVo userVo) {
        // 发送数据生命周期日志  数据审核 编辑标签消息到kafka
        final DataLifecycleLog manualOperateLog;
        final Subjectdatabase subjectdatabase = new Subjectdatabase();
        BeanUtil.copyProperties(specialInformation, subjectdatabase, CopyOptions.create().ignoreError().ignoreNullValue());
        String subjectName = subjectdatabase.getSubjectName();
        if (StringUtils.isEmpty(subjectName)) {
            String subjectId = subjectdatabase.getSubjectId();
            if (category == 1) {
                Subject subject = subjectService.getOne(new LambdaQueryWrapper<Subject>()
                        .eq(Subject::getId, subjectId)
                        .select(Subject::getSubjectName));
                subjectName = Optional.ofNullable(subject).orElse(new Subject()).getSubjectName();
            } else if (category == 2) {
                Event event = eventService.getOne(new LambdaQueryWrapper<Event>()
                        .eq(Event::getId, subjectId)
                        .select(Event::getEventName));
                subjectName = Optional.ofNullable(event).orElse(new Event()).getEventName();
            }
            subjectdatabase.setSubjectName(subjectName);
        }
        String sourceName;
        final InfoSource infoSource = infoSourceService.getOne(new QueryWrapper<InfoSource>()
                .eq("id", subjectdatabase.getSid())
                .select("site_name"));
        if (infoSource == null) {
            sourceName = Optional.ofNullable(
                            keyWordsService.getOne(new QueryWrapper<KeyWords>()
                                    .eq("id", subjectdatabase.getSid())
                                    .select("words_name")))
                    .orElse(new KeyWords())
                    .getWordsName();
        } else {
            sourceName = infoSource.getWebSiteName();
        }
        final String operateUser = userVo != null ? userVo.getRealname() : "未知用户";
        manualOperateLog = DataLifecycleLog.createManualOperateLog(subjectdatabase, operateUser, enumOperateWay, sourceName, labelNameList);
        kafkaTemplate.send("data_lifecycle_log_manual_operate", JSONUtil.toJsonStr(manualOperateLog));
    }


    //信息加上分类
    public void setInfoSourceType(SpecialInformation data) {
        String url = Utility.domainURL(data.getSourceAddress());
        String typeNum;
        if (StringUtils.isNotEmpty(url)) {
            if (redisUtil.get(Constants.SITE_NAME_KEY + url) != null) {
                typeNum = (String) redisUtil.get(Constants.SITE_NAME_KEY + url);
            } else {
                typeNum = "12";
            }
        } else {
            typeNum = "12";
        }
        data.setInfoSourceType(typeNum);
    }

    private List<Label> getInfoSourceLabel(String origin,String sourceAddress){
        List<String> sidList = new ArrayList<>();
        if (StringUtils.isNotEmpty(origin)) {
            LambdaQueryWrapper<InfoSource> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(InfoSource::getSiteName, origin);
            InfoSource infoSource = infoSourceService.getOne(queryWrapper);
            if (infoSource != null) {
                String sid = infoSource.getId();
                sidList.add(sid);
            } else {
                if (StringUtils.isNotEmpty(sourceAddress)) {
                    String url = Utility.domainURL(sourceAddress);
                    if (StringUtils.isNotEmpty(url)) {
                        LambdaQueryWrapper<InfoSource> query = Wrappers.lambdaQuery();
                        query.like(InfoSource::getSiteUri, url);
                        List<InfoSource> sourceList = infoSourceService.list(query);
                        if (CollectionUtils.isNotEmpty(sourceList)) {
                            sidList = sourceList.stream().map(InfoSource::getId).collect(Collectors.toList());
                        }
                    }
                }
            }
        }
        List<Label> labels = new ArrayList<>();
        List<LabelItemMapVO> clbLabelItems = commonService.infoSourceLabelsBySidList(sidList);
        Label label = new Label();
        if (CollectionUtils.isNotEmpty(clbLabelItems)) {
            LabelItemMapVO clbLabelItem = clbLabelItems.get(0);
            label.setSourceId(clbLabelItem.getEntityCode());
            label.setLabelMark(clbLabelItem.getLabelCode());
            label.setRelationId(clbLabelItem.getLabelCode() + "-" +clbLabelItem.getLabelItemCode());
        } else {//默认其他
            label.setLabelMark("LABEL-20250102-0006");
            label.setRelationId("LABEL-20250102-0006-LV-20250102-0026");
        }
        labels.add(label);
        return labels;
    }
}
