package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.sql.Date;
import java.util.List;

/**
 * 简化流程后的入参对象-研究中心
 *
 * @author lkg
 * @date 2025/1/9
 */
@Data
public class SubjectSimpleVO {

    private String id;
    private String subjectName;
    private String subjectTypeId;
    private String projectId;
    /**定时单位(1分；2小时；3日；4月)*/
    private String unit;
    /**定时数值*/
    private Integer space;
    private String remark;
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeEnable;
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeDisable;
    private String library;
    private Integer dataSource;
    private Integer facePublic;
    /**关键词*/
    private List<SearchWordVO> keywords;
}
