package com.zzsn.event.service.impl;

import cn.hutool.core.io.FileUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.ClbSysAttachment;
import com.zzsn.event.mapper.ClbSysAttachmentMapper;
import com.zzsn.event.service.IClbSysAttachmentService;
import com.zzsn.event.util.ObsUtil;
import com.zzsn.event.vo.es.AttachmentInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 附件表
 * @Author: jeecg-boot
 * @Date: 2022-11-22
 * @Version: V1.0
 */
@Service
public class ClbSysAttachmentServiceImpl extends ServiceImpl<ClbSysAttachmentMapper, ClbSysAttachment> implements IClbSysAttachmentService {

    @Autowired
    private ObsUtil obsUtil;

    @Override
    public List<AttachmentInfo> fileUpload(Map<String, MultipartFile> fileMap) {
        List<AttachmentInfo> result = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            MultipartFile file = entry.getValue();
            int index = file.getOriginalFilename().lastIndexOf(".");
            String fileSuffix = file.getOriginalFilename().substring(index + 1);
            try {
                String url = obsUtil.uploadFile("SubjectUp/" + file.getOriginalFilename(), file.getInputStream()).getObjectKey();
                ClbSysAttachment clbSysAttachment = new ClbSysAttachment()
                        .setName(file.getOriginalFilename())
                        .setObjectKey(url)
                        .setBucketName("zzsn")
                        .setTypeId("15")
                        .setStatus(1)
                        .setOrderBy(0)
                        .setCreateTime(new Date())
                        .setFileSize(FileUtil.readableFileSize(file.getSize()));
                this.save(clbSysAttachment);
                AttachmentInfo attachmentInfo = new AttachmentInfo();
                attachmentInfo.setAttachmentName(file.getOriginalFilename());
                attachmentInfo.setAttachmentFullPath(Constants.OBS_FILE_PATH_URL_PREFIX + url);
                attachmentInfo.setCategory(fileSuffix);
                attachmentInfo.setFileSize(FileUtil.readableFileSize(file.getSize()));
                attachmentInfo.setAttachmentId(clbSysAttachment.getId().toString());
                result.add(attachmentInfo);
            } catch (IOException e) {
                log.error("文件上传异常，请检查文件上传服务器。");
            }
        }
        return result;
    }
}
