package com.zzsn.event.controller.yjzx;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.constant.Result;
import com.zzsn.event.service.EsStatisticsService;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.EventExcelVO;
import com.zzsn.event.vo.EventRegionVO;
import com.zzsn.event.vo.EventTopVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 事件首页
 *
 * @author lkg
 * @date 2024/4/8
 */
@Slf4j
@RestController
@RequestMapping("/home")
public class EventHomeController {

    @Autowired
    private EsStatisticsService esStatisticsService;
    @Autowired
    private IEventService eventService;

    @Value(("${yjzx.url.checkToken:http://106.38.99.147:20592/user/urUser/getUserByToken?token=}"))
    private String checkToken;


    /**
     * 事件数据统计-首页
     *
     * @param projectId 项目id
     * @author lkg
     * @date 2024/9/18
     */
    @GetMapping(value = "/eventData")
    public Result<?> eventData(@RequestParam(defaultValue = "1476527644425682945") String projectId) {
        UserVo loginUser = UserUtil.getLoginUser();
        String username = loginUser.getUsername();
        Map<String, Integer> map = new HashMap<>();
        List<EventExcelVO> eventList = eventService.frontAllList(projectId, username, null, null,null,null,null,null);
        map.put("eventCount", eventList.size());
        if (!CollectionUtils.isEmpty(eventList)) {
            List<String> eventIdList = eventList.stream().map(EventExcelVO::getId).collect(Collectors.toList());
            long total = esStatisticsService.totalCount(eventIdList, null, null);
            map.put("total", (int) total);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime previousHour = now.minus(1, ChronoUnit.DAYS);
            long totalAdd = esStatisticsService.totalCount(eventIdList, previousHour.format(formatter), now.format(formatter));
            map.put("totalAdd", (int) totalAdd);
        } else {
            map.put("total", 0);
            map.put("totalAdd", 0);
        }
        return Result.OK(map);
    }


    /**
     * 热点事件-前10
     *
     * @param projectId 项目id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      分类(1-按发布时间;2.按热度)
     * @param size      返回个数
     * @author lkg
     * @date 2024/9/18
     */
    @GetMapping("/hotEventFlow")
    public Result<?> hotEventFlow(@RequestParam(defaultValue = "1476527644425682945") String projectId,
                                  @RequestParam(required = false) String startTime,
                                  @RequestParam(required = false) String endTime,
                                  @RequestParam Integer type,
                                  @RequestParam(defaultValue = "10") Integer size) {
        UserVo loginUser = UserUtil.getLoginUser();
        String username = loginUser.getUsername();
        List<EventTopVO> list = eventService.topEventList(projectId, username, startTime, endTime, type, size);
        return Result.OK(list);
    }


    /**
     * 事件按地域分析
     *
     * @param projectId  项目id
     * @param type       地域类型(1-国际;2-国内)
     * @param regionName 地域名称
     * @author lkg
     * @date 2024/9/18
     */
    @GetMapping("/region")
    public Result<?> region(@RequestParam(defaultValue = "1476527644425682945") String projectId,
                            @RequestParam Integer type,
                            @RequestParam(required = false) String regionName) {
        UserVo loginUser = UserUtil.getLoginUser();
        String username = loginUser.getUsername();
        List<Map<String, Object>> dataList = new ArrayList<>();
        List<EventRegionVO> eventRegionVOList = eventService.listByRegion(projectId,username,type, regionName);
        Map<String, List<EventRegionVO>> map = eventRegionVOList.stream().collect(Collectors.groupingBy(EventRegionVO::getRegionName));
        for (Map.Entry<String, List<EventRegionVO>> entry : map.entrySet()) {
            Map<String, Object> regionMap = new HashMap<>();
            regionMap.put("region", entry.getKey());
            regionMap.put("events", entry.getValue());
            regionMap.put("count", entry.getValue().size());
            dataList.add(regionMap);
        }
        return Result.OK(dataList);
    }
    /**
     * 权限校验
     * @param token 研究中心token
     * @author yanxin
     * @date 2025/2/20
     */
    @GetMapping("/checkAuth")
    public Result<?> checkAuth(@RequestParam String token,@RequestParam String key) {
        try{
            String res = HttpUtil.get(checkToken + token);
            JSONObject data = JSONObject.parseObject(res).getJSONObject("data");
            if(data == null){
                return Result.FAIL("token失效");
            }
            JSONArray powerCodeSet = data.getJSONArray("powerCodeSet");
            return Result.OK(powerCodeSet.contains(key));
        }catch (Exception e){
            log.error("研究中心用户权限校验异常,e:{}",e.getMessage(),e);
        }
        return Result.OK(false);
    }

}
