package com.zzsn.event.constant;

import lombok.Data;

import java.io.Serializable;

/**
 *   接口返回数据格式
 * @author scott
 * @email jeecgos@163.com
 * @date  2019年1月19日
 */
@Data
public class Result<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 成功标志
	 */
	private boolean success = true;

	/**
	 * 返回处理消息
	 */
	private String message = "操作成功！";

	/**
	 * 返回代码
	 */
	private Integer code = 0;
	
	/**
	 * 返回数据对象 data
	 */
	private T result;
	
	/**
	 * 时间戳
	 */
	private long timestamp = System.currentTimeMillis();


	public Result() {}


	public static<T> Result<T> OK() {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(200);
		r.setMessage("成功");
		return r;
	}

	public static<T> Result<T> OK(T data) {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(200);
		r.setResult(data);
		return r;
	}

	public static<T> Result<T> OK(String message,T data) {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(200);
		r.setMessage(message);
		r.setResult(data);
		return r;
	}

	public static<T> Result<T> FAIL() {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(500);
		r.setMessage("失败");
		return r;
	}

	public static<T> Result<T> FAIL(String message) {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(500);
		r.setMessage(message);
		return r;
	}

	public static<T> Result<T> FAIL(Integer code,String message) {
		Result<T> r = new Result<T>();
		r.setSuccess(true);
		r.setCode(code);
		r.setMessage(message);
		return r;
	}
}