package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件分析报告
* @TableName event_analysis_report
*/
@Data
@TableName("event_analysis_report")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="EventAnalysisReport对象", description="事件分析报告")
public class EventAnalysisReport implements Serializable {

    /**
    * 主键id
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 事件id
    */
    @TableField("event_id")
    private String eventId;
    /**
    * 报告名称
    */
    @TableField("report_name")
    private String reportName;
    /**
    * 报告内同
    */
    @TableField("content")
    private String content;
    /**
    * 文件路径
    */
    @TableField("file_path")
    private String filePath;
    /**
    * 入库时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
}
