package com.zzsn.event.neo4j.controller;

import com.zzsn.event.constant.Result;
import com.zzsn.event.neo4j.service.AtlasService;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "图谱查询")
@RestController
@RequestMapping("/atlas")
public class AtlasController {

    @Autowired
    AtlasService atlasService;

    @RequestMapping("/test")
    public Result<?> test(String sql ,String databaseName){

        return atlasService.test(sql,databaseName);
    }
    @RequestMapping("/test1")
    public Result<?> test1(String name ,String databaseName){

        return atlasService.test1(name,databaseName);
    }
    @GetMapping("/getAtlasBysubjectId")
    public Result<?> getAtlasBysubjectId(String subjectId){
        return atlasService.getAtlasBysubjectId(subjectId);
    }
    @GetMapping("/getAtlasBysubjectIdAndName")
    public Result<?> getAtlasBysubjectIdAndName(String subjectId,String name){
        return atlasService.getAtlasBysubjectIdAndName(subjectId,name);
    }


}
