package com.zzsn.event.util;

import com.zzsn.event.controller.reportData.FieldDescription;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * 实体字段工具类
 *
 * @author lkg
 * @date 2025/4/9
 */
public class FieldUtil {

    public static List<Map<String, Object>> requestFieldDetails(Class<?> clazz) {
        List<Map<String, Object>> list = new ArrayList<>();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            Map<String, Object> fieldMap = new TreeMap<>();
            FieldDescription fieldAnnotation = field.getAnnotation(FieldDescription.class);
            if (fieldAnnotation != null && fieldAnnotation.valid()) {
                fieldMap.put("fieldName", field.getName());
                fieldMap.put("fieldType", field.getType().getSimpleName());
                fieldMap.put("fieldDescription", fieldAnnotation.value());
                if (List.class.isAssignableFrom(field.getType())) {
                    Class<?> elementType = getCollectionElementType(field.getGenericType());
                    if (elementType.isAssignableFrom(Integer.class)) {
                        fieldMap.put("fieldType", field.getType().getSimpleName() + "<Integer>");
                    } else if (elementType.isAssignableFrom(String.class )) {
                        fieldMap.put("fieldType", field.getType().getSimpleName() + "<String>");
                    } else {
                        List<Map<String, Object>> children = requestFieldDetails(elementType);
                        fieldMap.put("children", children);
                    }
                }
                list.add(fieldMap);
            }
        }
        return list;
    }

    public static List<Map<String, Object>> responseFieldDetails(Class<?> clazz) {
        List<Map<String, Object>> list = new ArrayList<>();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            Map<String, Object> fieldMap = new TreeMap<>();
            FieldDescription fieldAnnotation = field.getAnnotation(FieldDescription.class);
            if (fieldAnnotation != null && fieldAnnotation.valid()) {
                fieldMap.put("fieldName", field.getName());
                fieldMap.put("fieldType", field.getType().getSimpleName());
                fieldMap.put("fieldDescription", fieldAnnotation.value());
                list.add(fieldMap);
            }
        }
        return list;
    }

    private static Class<?> getCollectionElementType(java.lang.reflect.Type collectionType) {
        if (collectionType instanceof java.lang.reflect.ParameterizedType) {
            java.lang.reflect.ParameterizedType aType = (java.lang.reflect.ParameterizedType) collectionType;
            java.lang.reflect.Type[] fieldArgTypes = aType.getActualTypeArguments();
            for (java.lang.reflect.Type fieldArgType : fieldArgTypes) {
                return (Class<?>) fieldArgType; // 返回第一个元素的类型，通常集合只有一个泛型参数
            }
        }
        return Object.class; // 如果没有找到泛型类型，返回Object类
    }
}
