package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 专题-概述分析实体
 *
 * @author lkg
 * @date 2024/12/26
 */
@Getter
@Setter
public class OverviewAnalysisVO {

    /**专题名称*/
    private String subjectName;
    /**启用时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeEnable;
    /**停用时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date timeDisable;
    /**资讯数量*/
    private Integer infoCount;
    /**各分类下信息源数量*/
    private List<CountVO> countList;
}
