package com.zzsn.event.mapper;

import com.zzsn.event.entity.SubjectDictMap;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.DictVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * @author lenovo
 * @description 针对表【subject_dict_map(专题-字典关系表)】的数据库操作Mapper
 * @createDate 2025-03-28 11:56:32
 * @Entity com.zzsn.event.entity.SubjectDictMap
 */
@Mapper
public interface SubjectDictMapMapper extends BaseMapper<SubjectDictMap> {

    /**
     * 专题绑定的数据字典信息
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/3/28
     */
    List<DictVO> boundList(@Param("subjectId") String subjectId);

    List<String> boundIdList(@Param("subjectId") String subjectId);

    /**
     * 流程中标签模型绑定的数据字典信息
     *
     * @param subjectId
     * @return
     */
    List<DictVO> boundArrangeList(@Param("subjectId") String subjectId);

    /**
     * 老逻辑中标签模型绑定的数据字典信息
     *
     * @param subjectId
     * @return
     */
    List<DictVO> boundOldList(@Param("subjectId") String subjectId);

    /**
     * 查询非数据字典的标签类型
     *
     * @param ids
     * @return
     */
    List<DictVO> findLabelType(@Param("ids") List<String> ids);

    List<DictVO> findLeaderLabelType(@Param("ids") List<String> ids);
}




