package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.ClbLabel;
import com.zzsn.event.vo.InfoSourceLabelVO;
import com.zzsn.event.vo.LabelDictItemVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-08-23
 */
@Mapper
public interface ClbLabelMapper extends BaseMapper<ClbLabel> {

    /**
     * 专题绑定的信息源标签信息
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/2
     */
    List<InfoSourceLabelVO> bindInfoSourceLabelInfo(@Param("subjectId") String subjectId);

    /**
     * 获取分类下的标签信息
     *
     * @param labelTypeId 标签分类id
     * @author lkg
     * @date 2025/1/2
     */
    List<InfoSourceLabelVO> labelInfoByType(@Param("labelTypeId") String labelTypeId);

    List<String> subjectBindMainLabelList(@Param("subjectId") String subjectId);
    List<LabelDictItemVO> subjectBindMainLabels(@Param("subjectId") String subjectId);
}
