package com.zzsn.event.vo;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lkg
 * @description:
 * @date 2022/7/19 15:10
 */
@Data
public class SubjectDataVo {

    private String id;
    //关联专题id
    private String subjectId;
    //标题
    private String title;
    //摘要
    private String summary;
    //正文
    private String content;
    //带标签正文
    private String contentWithTag;
    //来源（信息来源）
    private String origin;
    //发布地址
    private String sourceAddress;
    //发布时间
    private String publishDate;
    //入库时间
    private String createDate;
    //（flag!=0：主条目  flag=0：非主条目）
    private String flag;
    //关联的主条目id
    private String masterEntryId;
    //原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系)
    private String originalId;
    //关键词
    private String keyWords;
    //信息源类型（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它）
    private String infoSourceType;
    //重复id
    private String repeatId;

    public List<String> toList(){
        List<String> list = new ArrayList<>();
        list.add(id);
        list.add(title);
        list.add(summary);
        list.add(content);
        list.add(publishDate);
        list.add(origin);
        list.add(sourceAddress);
        return list;
    }
}
