package com.zzsn.event.vo;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class SpecialInformationParam extends SpecialInformation{
    //的索引名
    private String dbIndex;
    //查询es时需要包含的字段 多个使用,分隔
    public String sourceInclude;
    //查询es时需要排除的字段 多个使用,分隔
    public String sourceExclude;

    //舆情推送检索：yqts 舆情预警检索：yqyj
    private String searchType;
    //检索关键词
    private String searchKey;
    //分类标签id，多个使用逗号分隔
    private String searchLabelIds;
    //不查询的分类id，多个使用逗号分隔
    private String excludeLabelIds;
    //分类标签，多个使用逗号分隔
    private String labelMarks;
    //状态（多个使用逗号分隔）
    private String findStatus;
    //发布状态（多个使用逗号分隔）
    private String findPublishStatus;
    //情报开始时间
    private String startTime;
    //情报结束时间
    private String endTime;
    //发布开始时间
    private String publishStartTime;
    //发布结束时间
    private String publishEndTime;
    //页码
    private Integer pageNo = 1;
    //每页数据条数
    private Integer pageSize = 10;
    //排序规则
    private String column = "common";
    //排序方式
    private String order = "desc";
    //高级查询-规则
    private String superQueryMatchType;
    //高级查询-条件（url转码后的json）
    private String superQueryParams;
    //是否包含图片
    private Integer hasImg;
    //栏目id
    private String channelId;
    //栏目组id
    private String channelGroupId;
    //取置顶第一条数据的封面图
    private Integer hasBanner;
    /**舆情推送业务参数：begin*/
    //前端传参，关注项id
    private String attentionIds;
    private String resourceCatalogId;
    private String orientation;
    //检索条件 用于关注栏目配置 key为栏目id，value为关注类型，0:全部 1:正面 2:中性 3:负面
    private Map<String,String> attentionMap;
    /**舆情推送业务参数：end*/
    /**舆情预警业务参数：begin*/
    /**
     * 预警类型 2系统预警 3自定义预警
     */
    private Integer warningType;
    /**
     * 信息区域
     */
    private Map<String,String> articleAreaMap;
    /**
     * 互动数
     */
    private Map<String,Integer> interactionNumberMap;
    /**
     * 粉丝数
     */
    private  Map<String,Integer> fansNumberMap;
    /**
     * 阅读数
     */
    private  Map<String,Integer> readNumberMap;
    /**
     * 相似文章个数
     */
    private Map<String,Integer> similarNumberMap;
    //检索条件 用于舆情预警配置 key为栏目id，value为舆情预警类型，0:全部 1:正面 2:中性 3:负面
    private Map<String,String> pushTypeMap;

    /**资讯是否包含图片，1：资讯包含图片    0：资讯不包含图片*/
    private Map<String,String> isIncludeImgMap;
    /**
     * 精准筛选（1 开启 0 关闭）
     */
    private Map<String,Integer> accurateFilterMap;
    private Map<String,String> infoSourceTypeIdsMap;
    /**舆情预警业务参数：end*/


    /**抖音微博作品点赞数*/
    private Integer likeNum;
    /**抖音微博贴吧作品评论数*/
    private Integer commentNum;
    /**抖音收藏数*/
    private Integer collectNum;
    /**抖音微博 分享数*/
    private Integer shareNum;
    /**作品、帖子唯一标识*/
    private String articleId;
    /**信息源类别id*/
    private String infoSourceTypeId;
    /**信息源性质id*/
    private String infoSourceNatureId;
    /**资讯是否包含图片，1：资讯包含图片    0：资讯不包含图片*/
    private String isIncludeImg;
    //关键词
    private List<String> keyWordsList;

}
