package com.zzsn.event.producer;

import com.alibaba.fastjson.JSON;

import com.zzsn.event.vo.KeyWordsDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
@EnableBinding(IInfosourceSource.class)
public class ProduceInfo {

    @Autowired
    private IInfosourceSource source;



    /*
    * 专题拉取数据
    * @param info 专题编码
    * */
    public void sendSubjectMsg(String subjectCode) {
        Message<String> message = MessageBuilder.withPayload(subjectCode).build();
        source.subjectModel().send(message);
        log.info("专题投递到kafka成功,topic:subjectModel, subjectCode=[{}]", subjectCode);
    }

    /**
     * 关键词执行
     * @param keyWordsDTO 关键词信息源
     */
    public void sendKeyWordsInfoSourceMsg(KeyWordsDTO keyWordsDTO) {
        try{
            String msg = JSON.toJSONString(keyWordsDTO);
            Message<String> message = MessageBuilder.withPayload(msg).build();
            source.keyWordsCrawl().send(message);
        }catch (Exception e){
            log.error("关键词："+ keyWordsDTO.getWordsCode() + "推送kafka失败");
        }
    }

}
