package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author lkg
 * @description: 观点分析响应数据封装
 * @date 2022/7/8 11:35
 */
@Data
public class ViewPointAnalysisVo {

    //资讯id
    private String dataId;
    //标题
    private String title;
    //来源
    private String origin;
    //发布时间
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date publishDate;
    //链接
    private String sourceAddress;
    /*重复数*/
    private Integer repeatNum;
    //占比
    private String percentage;
    //观点分析下的类型(1-新闻；2-论坛；3-微博)
    private Integer type;
}
