package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.service.*;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.vo.PropagationPathVo;
import com.zzsn.event.vo.SubjectDataVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lkg
 * @description:
 * @date 2022/7/20 11:32
 */
@Service
public class AnalysisServiceImpl implements AnalysisService {

    @Autowired
    private SubjectAnalysisService subjectAnalysisService;
    @Autowired
    private IEventService eventService;
    @Autowired
    private EsService esService;

//
//    @Override
//    public Map<String, List<ViewPointAnalysisVo>> viewPointAnalysis(String subjectId) {
//        Map<String, List<ViewPointAnalysisVo>> map = new HashMap<>();
//        List<SubjectAnalysis> viewPointList = getList(subjectId, 1);
//        if (CollectionUtils.isNotEmpty(viewPointList)) {
//            Map<Integer, List<SubjectAnalysis>> collect = viewPointList.stream().collect(Collectors.groupingBy(SubjectAnalysis::getType));
//            collect.forEach((type, value) -> {
//                List<ViewPointAnalysisVo> list = new ArrayList<>();
//                String name = ViewPointEnum.getNameByType(type);
//                //求和
//                int sum = value.stream().mapToInt(SubjectAnalysis::getRepeatNum).sum();
//                value.forEach(e -> {
//                    ViewPointAnalysisVo vo = new ViewPointAnalysisVo();
//                    BeanUtils.copyProperties(e, vo);
//                    //计算百分比
//                    String divide = CalculateUtil.divide(String.valueOf(e.getRepeatNum()), String.valueOf(sum));
//                    if (StringUtils.isNotEmpty(divide)) {
//                        String percentage = CalculateUtil.percentage(Double.parseDouble(divide));
//                        vo.setPercentage(percentage);
//                    }
//                    list.add(vo);
//                });
//                map.put(name, list);
//            });
//        }
//        return map;
//    }
//
    /*
     * 优先级：事件脉络 > 伪事件脉络 > 资讯
     * 1.若事件脉络资讯数量少于展示伪事件脉络的阈值(6)，若有伪事件脉络就展示，若无则根据发布时间倒序后，默认取前15条资讯为事件脉络。
     * 2.若事件脉络资讯数量少于展示伪事件脉络的阈值(6)但不为空；
     * 2.1 若有伪事件脉络就展示，若无则展示事件脉络；
     * 2.2 若有伪事件脉络就展示，若无则根据发布时间倒序后，默认取前15条资讯为事件脉络。
     * 3.若事件脉络资讯数量大于/等于展示伪事件脉络的阈值(6)，则直接展示
     *
     * 此种情况一般是专题资讯少或者刚建立的专题的事件专题，才会触发。
     */
    @Override
    public List<SubjectAnalysis> eventContext(String subjectId, int fakeNum) {
        //专题下的事件脉络
        List<SubjectAnalysis> list = getList(subjectId, 2);
        if (list.size() < fakeNum) {
            //专题下的伪事件脉络
            List<SubjectAnalysis> fakeList = getList(subjectId, 3);
            if (CollectionUtils.isEmpty(fakeList)) {
                if (CollectionUtils.isEmpty(list)) {
                    List<SubjectAnalysis> finalList = new ArrayList<>();
                    List<SubjectDataVo> dataList = esService.getDataBySubjectId(subjectId, null, null, "0", Constants.FETCH_FIELDS_STATISTIC, 1, 1, 15);
                    dataList.forEach(e -> {
                        SubjectAnalysis subjectAnalysis = new SubjectAnalysis();
                        BeanUtils.copyProperties(e, subjectAnalysis);
                        subjectAnalysis.setPublishDate(DateUtil.stringToDate(e.getPublishDate(), "yyyy-MM-dd HH:mm:ss"));
                        List<SubjectDataVo> subjectDataVoList = esService.dataById(subjectId, e.getId());
                        subjectAnalysis.setRepeatNum(subjectDataVoList.size());
                        finalList.add(subjectAnalysis);
                    });
                    list = finalList;
                }
            } else {
                list = fakeList;
            }
        }
        return list;
    }


    @Override
    public PropagationPathVo propagationPath(String subjectId) {
        Event event = eventService.getById(subjectId);
        String subjectName = event.getEventName();
        List<PropagationPathVo> children = new ArrayList<>();
        //获取专题数据
        List<SubjectDataVo> specialDataList = getSubjectData(event, "0", Constants.FETCH_FIELDS_STATISTIC,1);
        if (CollectionUtils.isNotEmpty(specialDataList)) {

            //最早发布的时间
            String publishDate = specialDataList.get(0).getPublishDate();
            String earlyTime;
            if (publishDate.length() > 10) {
                earlyTime = DateUtil.formatStr(publishDate, "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd");
            } else {
                earlyTime = publishDate;
            }
            //获取最早发布的信息,若过多，取前一个
            List<SubjectDataVo> earlyList = specialDataList.stream()
                    .filter(subjectDataVo -> {
                        String date = subjectDataVo.getPublishDate();
                        if (date.length() > 10) {
                            date = DateUtil.formatStr(date, "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd");
                        }
                        return earlyTime.equals(date);
                    })
                    .collect(Collectors.toList());
            if (earlyList.size() > 1) {
                earlyList = earlyList.subList(0, 1);
            }
            Map<SubjectDataVo, List<SubjectDataVo>> map = new HashMap<>();
            //获取跟最早发布的信息的重复信息
            earlyList.forEach(e -> {
                List<SubjectDataVo> subjectDataVoList = esService.dataById(subjectId, e.getId());
                if (CollectionUtils.isNotEmpty(subjectDataVoList)) {
                    map.put(e, subjectDataVoList);
                }
            });
            //若最早发布的信息没有重复数据，则随机补充10个重复数最多的信息来源
            // 本不该有的逻辑，奈何数据采集、处理 不给力
            if (map.isEmpty()) {
                for (SubjectDataVo subjectDataVo : earlyList) {
                    PropagationPathVo vo = new PropagationPathVo();
                    String topOrigin = subjectDataVo.getOrigin();
                    vo.setName(topOrigin);
                    //
                    vo.setChildren(pathByRepeat(topOrigin, event));
                    children.add(vo);
                }
            } else {//正常逻辑
                Map<SubjectDataVo, LinkedHashMap<String, List<SubjectDataVo>>> dataMap = new HashMap<>();
                for (Map.Entry<SubjectDataVo, List<SubjectDataVo>> entry : map.entrySet()) {
                    SubjectDataVo information = entry.getKey();
                    List<SubjectDataVo> value = entry.getValue();
                    //按来源分组
                    Map<String, List<SubjectDataVo>> originMap = value.stream().filter(e -> StringUtils.isNotEmpty(e.getOrigin()))
                            .collect(Collectors.groupingBy(SubjectDataVo::getOrigin));
                    //按统一来源信息数量 倒序 并截取前10
                    LinkedHashMap<String, List<SubjectDataVo>> orderMap = new LinkedHashMap<>();
                    originMap.entrySet().stream()
                            .sorted((o1, o2) -> o2.getValue().size() - o1.getValue().size()).limit(10)
                            .collect(Collectors.toList()).forEach(info -> orderMap.put(info.getKey(), info.getValue()));
                    dataMap.put(information, orderMap);
                }
                children = getPath(dataMap);
            }
        }
        PropagationPathVo pathVo = null;
        if (CollectionUtils.isNotEmpty(children)) {
            pathVo = new PropagationPathVo();
            pathVo.setName(subjectName);
            if(null!=children.get(0)){
                pathVo.setChildren(children.get(0).getChildren());
            }

        }
        return pathVo;
    }
//
//    @Override
//    public Map<String, Object> statisticAnalysis(String subjectId) {
//        Map<String, Object> map = new HashMap<>();
//        Subject subject = subjectService.getById(subjectId);
//        //获取专题数据
//        List<SubjectDataVo> specialDataList = getSubjectData(subject, "0", Constant.FETCH_FIELDS_STATISTIC,2);
//        if (CollectionUtils.isNotEmpty(specialDataList)) {
//            /*
//             * 按信息源类型分组--infoSourceType
//             * 因数据处理部分，未给信息源进行分类，故先按来源(origin)进行分组
//             */
//            Map<String, List<SubjectDataVo>> originMap = specialDataList.stream().filter(e -> StringUtils.isNotEmpty(e.getInfoSourceType()))
//                    .collect(Collectors.groupingBy(SubjectDataVo::getInfoSourceType));
//            //获取信息分散在的日期
//            Set<String> timeList = specialDataList.stream().collect(Collectors.groupingBy(e -> e.getPublishDate().substring(0, 10))).keySet();
//            List<CountVo> countVoList = new ArrayList<>();
//            Map<String, List<CountVo>> countMap = new HashMap<>();
//            originMap.forEach((key, value) -> {
//                //统计占比-饼状图
//                CountVo countVo = new CountVo();
//                String typeName = InfoSourceTypeEnum.getNameByCode(key);
//                countVo.setName(typeName);
//                countVo.setValue(value.size());
//                countVoList.add(countVo);
//                //数量统计-折线图
//                List<CountVo> countVos = statisticCount(typeName, value, timeList);
//                countMap.put(typeName, countVos);
//            });
//            if (CollectionUtils.isNotEmpty(countVoList)) {
//                map.put("ratio", countVoList);
//                map.put("count", countMap);
//            }
//        }
//        return map;
//    }
//
//    @Override
//    public List<StatisticAnalysisVo> statisticAnalysis(String subjectId, String startTime, String endTime) {
//        List<SubjectDataVo> dataList = esService.getDataBySubjectId(subjectId, startTime, endTime, "0", Constant.FETCH_FIELDS_STATISTIC, 2, null, null);
//        List<StatisticAnalysisVo> resultList = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dataList)) {
//            /*
//             * 按信息源类型分组--infoSourceType
//             * 因数据处理部分，未给信息源进行分类，故先按来源(origin)进行分组
//             */
//            Map<String, List<SubjectDataVo>> originMap = dataList.stream().filter(e -> StringUtils.isNotEmpty(e.getInfoSourceType()))
//                    .collect(Collectors.groupingBy(SubjectDataVo::getInfoSourceType));
//            //获取信息分散在的日期
//            Set<String> timeList = dataList.stream().collect(Collectors.groupingBy(e -> e.getPublishDate().substring(0, 10))).keySet();
//            originMap.forEach((key, value) -> {
//                StatisticAnalysisVo statisticAnalysisVo = new StatisticAnalysisVo();
//                statisticAnalysisVo.setName(InfoSourceTypeEnum.getNameByCode(key));
//                statisticAnalysisVo.setNum(value.size());
//                List<StatisticAnalysisVo> keyList = new ArrayList<>();
//                //有数据的日期集合
//                List<String> dateList = new ArrayList<>();
//                value.stream().collect(Collectors.groupingBy(e -> e.getPublishDate().substring(0, 10))).forEach((time, data) -> {
//                    dateList.add(time);
//                    StatisticAnalysisVo vo = new StatisticAnalysisVo();
//                    vo.setKey(time);
//                    vo.setNum(data.size());
//                    vo.setName(DateUtil.formatStr(time, "yyyy-MM-dd", "yyyy-MM-dd 00:00:00"));
//                    keyList.add(vo);
//                });
//                //补充没有信息的日期 数据量为0
//                List<String> list = new ArrayList<>(timeList);
//                list.removeAll(dateList);
//                list.forEach(time -> {
//                    StatisticAnalysisVo analysisVo = new StatisticAnalysisVo();
//                    analysisVo.setName(DateUtil.formatStr(time, "yyyy-MM-dd", "yyyy-MM-dd 00:00:00"));
//                    analysisVo.setKey(time);
//                    analysisVo.setNum(0);
//                    keyList.add(analysisVo);
//                });
//                List<StatisticAnalysisVo> collect = keyList.stream().sorted(Comparator.comparing(StatisticAnalysisVo::getKey)).collect(Collectors.toList());
//                statisticAnalysisVo.setList(collect);
//                resultList.add(statisticAnalysisVo);
//            });
//        }
//        return resultList;
//    }
//
    private List<SubjectAnalysis> getList(String subjectId, Integer category) {
        LambdaQueryWrapper<SubjectAnalysis> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectAnalysis::getSubjectId, subjectId).eq(SubjectAnalysis::getCategory, category).orderByAsc(SubjectAnalysis::getPublishDate);
        return subjectAnalysisService.list(queryWrapper);
    }

    private List<SubjectDataVo> getSubjectData(Event event, String flag, String[] fetchFields, Integer sort) {
        String startDate = null;
        String endDate = null;
        if (event.getStartTime() != null) {
            startDate = DateUtil.dateToString(event.getStartTime(), "yyyy-MM-dd HH:mm:ss");
        }
        if (event.getEndTime() != null) {
            endDate = DateUtil.dateToString(event.getEndTime(), "yyyy-MM-dd HH:mm:ss");
        }
        return esService.getDataBySubjectId(event.getId(), startDate, endDate, flag, fetchFields, sort, null, null);
    }

    private List<PropagationPathVo> getPath(Map<SubjectDataVo, LinkedHashMap<String, List<SubjectDataVo>>> dataMap) {
        List<PropagationPathVo> list = new ArrayList<>();
        for (Map.Entry<SubjectDataVo, LinkedHashMap<String, List<SubjectDataVo>>> entry : dataMap.entrySet()) {
            PropagationPathVo pathVo = new PropagationPathVo();
            SubjectDataVo information = entry.getKey();
            pathVo.setName(information.getOrigin());
            List<PropagationPathVo> children = new ArrayList<>();
            Map<String, List<SubjectDataVo>> value = entry.getValue();
            for (Map.Entry<String, List<SubjectDataVo>> entry1 : value.entrySet()) {
                PropagationPathVo pathVo1 = new PropagationPathVo();
                pathVo1.setName(entry1.getKey());
                children.add(pathVo1);
            }
            pathVo.setChildren(children);
            list.add(pathVo);
        }
        return list;
    }
//
//    private List<CountVo> statisticCount(String origin, List<SubjectDataVo> list, Set<String> timeList) {
//        List<CountVo> countVoList = new ArrayList<>();
//        List<String> dateList = new ArrayList<>();
//        list.stream().collect(Collectors.groupingBy(e -> e.getPublishDate().substring(0, 10))).forEach((key, value) -> {
//            dateList.add(key);
//            CountVo countVo = new CountVo();
//            countVo.setName(origin);
//            countVo.setDate(key);
//            countVo.setValue(value.size());
//            countVoList.add(countVo);
//        });
//        //补充没有信息的 时间 数据量为0
//        List<String> allTimeList = new ArrayList<>(timeList);
//        allTimeList.removeAll(dateList);
//        allTimeList.forEach(time -> {
//            CountVo countVo = new CountVo();
//            countVo.setName(origin);
//            countVo.setDate(time);
//            countVo.setValue(0);
//            countVoList.add(countVo);
//        });
//        return countVoList;
//    }

    private List<PropagationPathVo> pathByRepeat(String topOrigin, Event event) {
        List<PropagationPathVo> childrenList = new ArrayList<>();
        TreeSet<String> topIdList = new TreeSet<>();
        List<SubjectDataVo> specialDataList = getSubjectData(event, null, Constants.FETCH_FIELDS_STATISTIC,2);
        Map<String, List<SubjectDataVo>> map = specialDataList.stream().filter(this::filterCondition)
                .collect(Collectors.groupingBy(SubjectDataVo::getMasterEntryId));
        map.entrySet().stream().sorted(((o1, o2) -> o2.getValue().size() - o1.getValue().size())).limit(10)
                .collect(Collectors.toList()).forEach(info -> topIdList.add(info.getKey()));
        if (CollectionUtils.isNotEmpty(topIdList)) {
            TreeSet<String> originSet = new TreeSet<>();
            for (String id : topIdList) {
                SubjectDataVo subjectDataVo = esService.queryInfo(id);
                String origin = subjectDataVo.getOrigin();
                if (StringUtils.isNotEmpty(origin)) {
                    originSet.add(origin);
                }
            }
            for (String origin : originSet) {
                if (!origin.equals(topOrigin)) {
                    PropagationPathVo propagationPathVo = new PropagationPathVo();
                    propagationPathVo.setName(origin);
                    childrenList.add(propagationPathVo);
                }
            }
        }
        return childrenList;
    }

    private boolean filterCondition(SubjectDataVo subjectDataVo) {
        boolean flag = false;
        String masterEntryId = subjectDataVo.getMasterEntryId();
        String origin = subjectDataVo.getOrigin();
        if (StringUtils.isNotEmpty(masterEntryId) && StringUtils.isNotEmpty(origin)) {
            flag = true;
        }
        return flag;
    }
}
