package com.zzsn.event.enums;

/**
 * @author zhang ya nuo
 * @Description 编码前缀枚举
 * @since 2021/6/8
 */
public enum CodePrefixEnum {
    INFO_SOURCE_DEFAULT("IN","信息源编码默认前缀"),
    SUBJECT_DEFAULT("SJ", "专题编码默认前缀"),
    PROJECT_DEFAULT("PJ", "项目编码默认前缀"),
    CUSTOMER_DEFAULT("CS", "客户编码默认前缀"),
    SPECIAL_INFO_SOURCE_DEFAULT("PY","信息源编码默认前缀"),
    INFO_SOURCE_GROUP_DEFAULT("ING","信息源组编码默认前缀"),
    KEY_WORDS_DEFAULT("KW", "关键词默认前缀"),
    SOCIAL_CREDIT_CODE_DEFAULT("ZZSN", "统一社会信用代码前缀"),
    QCC_ENTERPRISE_ID_DEFAULT("QCC", "老企业库ID"),
    COLUMN_CODE_DEFAULT("COL", "栏目编码默认前缀"),
    LABEL_CODE_DEFAULT("LABEL", "标签编码默认前缀");

    // 前缀
    private String value;
    // 描述信息
    private String des;

    CodePrefixEnum(String value, String des) {
        this.value = value;
        this.des = des;
    }


    public String getValue() {
        return value;
    }

    public String getDes() {
        return des;
    }

}
